/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.DateColumnUtils;
import tech.tablesaw.columns.IntColumnUtils;
import tech.tablesaw.columns.packeddata.PackedLocalDate;
import tech.tablesaw.index.DateIndex;
import tech.tablesaw.index.IntIndex;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.util.Selection;

public class IntIndexTest {
    private ColumnType[] types = new ColumnType[]{ColumnType.LOCAL_DATE, ColumnType.INTEGER, ColumnType.CATEGORY};
    private IntIndex index;
    private DateIndex dateIndex;
    private Table table;

    @Before
    public void setUp() throws Exception {
        this.table = Table.read().csv(CsvReadOptions.builder((String)"../data/BushApproval.csv").columnTypes(this.types));
        this.index = new IntIndex(this.table.intColumn("approval"));
        this.dateIndex = new DateIndex(this.table.dateColumn("date"));
    }

    @Test
    public void testGet() {
        Selection fromCol = this.table.intColumn("approval").select(IntColumnUtils.isEqualTo, 71);
        Selection fromIdx = this.index.get(71);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testGet2() {
        LocalDate date = LocalDate.of(2001, 12, 12);
        int packedDate = PackedLocalDate.pack((LocalDate)date);
        Selection fromCol = this.table.dateColumn("date").select(DateColumnUtils.isEqualTo, packedDate);
        Selection fromIdx = this.dateIndex.get(date);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testGTE() {
        Selection fromCol = this.table.intColumn("approval").select(IntColumnUtils.isGreaterThanOrEqualTo, 71);
        Selection fromIdx = this.index.atLeast(71);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testGTE2() {
        LocalDate date = LocalDate.of(2001, 12, 12);
        int packedDate = PackedLocalDate.pack((LocalDate)date);
        Selection fromCol = this.table.dateColumn("date").select(DateColumnUtils.isGreaterThanOrEqualTo, packedDate);
        Selection fromIdx = this.dateIndex.atLeast(date);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testLTE() {
        Selection fromCol = this.table.intColumn("approval").select(IntColumnUtils.isLessThanOrEqualTo, 71);
        Selection fromIdx = this.index.atMost(71);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testLT() {
        Selection fromCol = this.table.intColumn("approval").select(IntColumnUtils.isLessThan, 71);
        Selection fromIdx = this.index.lessThan(71);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testGT() {
        Selection fromCol = this.table.intColumn("approval").select(IntColumnUtils.isGreaterThan, 71);
        Selection fromIdx = this.index.greaterThan(71);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }
}

