/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.FloatColumnUtils;
import tech.tablesaw.index.FloatIndex;
import tech.tablesaw.util.Selection;

public class FloatIndexTest {
    private FloatIndex index;
    private Table table;

    @Before
    public void setUp() throws Exception {
        this.table = Table.read().csv("../data/bus_stop_test.csv");
        this.index = new FloatIndex(this.table.floatColumn("stop_lat"));
    }

    @Test
    public void testGet() {
        Selection fromCol = this.table.floatColumn("stop_lat").select(FloatColumnUtils.isEqualTo, 30.330425f);
        Selection fromIdx = this.index.get(30.330425f);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testGTE() {
        Selection fromCol = this.table.floatColumn("stop_lat").select(FloatColumnUtils.isGreaterThanOrEqualTo, 30.330425f);
        Selection fromIdx = this.index.atLeast(30.330425f);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testLTE() {
        Selection fromCol = this.table.floatColumn("stop_lat").select(FloatColumnUtils.isLessThanOrEqualTo, 30.330425f);
        Selection fromIdx = this.index.atMost(30.330425f);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testLT() {
        Selection fromCol = this.table.floatColumn("stop_lat").select(FloatColumnUtils.isLessThan, 30.330425f);
        Selection fromIdx = this.index.lessThan(30.330425f);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testGT() {
        Selection fromCol = this.table.floatColumn("stop_lat").select(FloatColumnUtils.isGreaterThan, 30.330425f);
        Selection fromIdx = this.index.greaterThan(30.330425f);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }
}

