/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filters;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.text.RandomStringGenerator;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.QueryHelper;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.columns.packeddata.PackedLocalDate;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.table.TemporaryView;
import tech.tablesaw.table.ViewGroup;

public class TimeDependentFilteringTest {
    private static final int CONCEPT_COUNT = 10;
    private static final int PATIENT_COUNT = 10000;
    private static List<String> concepts = new ArrayList<String>(10);
    private static IntArrayList patientIds = new IntArrayList(10000);
    private static int size = 21900;
    private static IntArrayList dates = new IntArrayList(size);

    public static void main(String[] args) throws Exception {
        int numberOfRecordsInTable = 100000;
        Stopwatch stopwatch = Stopwatch.createStarted();
        Table t = TimeDependentFilteringTest.defineSchema();
        TimeDependentFilteringTest.generateTestData(t, numberOfRecordsInTable, stopwatch);
        t.setName("Observations");
        String conceptA = t.categoryColumn("concept").get(RandomUtils.nextInt((int)0, (int)t.rowCount()));
        String conceptB = t.categoryColumn("concept").get(RandomUtils.nextInt((int)0, (int)t.rowCount()));
        String conceptZ = t.categoryColumn("concept").get(RandomUtils.nextInt((int)0, (int)t.rowCount()));
        String conceptD = t.categoryColumn("concept").get(RandomUtils.nextInt((int)0, (int)t.rowCount()));
        DependencyFilter independentConstraintFilter = DependencyFilter.FIRST;
        Range daysConstraint = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        ColumnReference concept = QueryHelper.column((String)"concept");
        Table nt = t.selectWhere(QueryHelper.both((Filter)concept.isEqualTo(conceptA), (Filter)concept.isNotEqualTo(conceptB)));
        IntColumn ntPatients = nt.intColumn("patient");
        ViewGroup patients = ViewGroup.create((Table)t, (String[])new String[]{"patient"});
        CopyOnWriteArrayList patientTables = new CopyOnWriteArrayList(patients.getSubTables());
        for (TemporaryView patientTable : patients) {
            CategoryColumn concepts = patientTable.categoryColumn("concept");
            int patientId = Integer.parseInt(patientTable.name());
            if (!concepts.contains(conceptZ) || concepts.contains(conceptD)) {
                patientTables.remove(patientTable);
                continue;
            }
            if (ntPatients.contains(patientId)) continue;
            patientTables.remove(patientTable);
        }
        ArrayList<IndependentResult> independentResults = new ArrayList<IndependentResult>();
        for (TemporaryView patientTable : patientTables) {
            IndependentResult result = new IndependentResult();
            ArrayList<LocalDate> eventDates = new ArrayList<LocalDate>();
            IntIterator intIterator = patientTable.iterator();
            while (intIterator.hasNext()) {
                int row = (Integer)intIterator.next();
                CategoryColumn concepts = patientTable.categoryColumn("concept");
                DateColumn dates = patientTable.dateColumn("date");
                if (!concepts.get(row).equals(conceptZ)) continue;
                eventDates.add(dates.get(row));
            }
            if (independentConstraintFilter == DependencyFilter.FIRST) {
                if (eventDates.isEmpty()) {
                    System.out.println(patientTable.name());
                } else {
                    LocalDate date = (LocalDate)eventDates.get(0);
                    result.addRange((Range<LocalDate>)Range.closed((Comparable)date.minusDays(((Integer)daysConstraint.lowerEndpoint()).intValue()), (Comparable)date.plusDays(((Integer)daysConstraint.upperEndpoint()).intValue())));
                }
            }
            independentResults.add(result);
        }
        System.out.println("Done");
    }

    private static Table defineSchema() {
        Table t = Table.create((String)"Observations");
        CategoryColumn conceptId = new CategoryColumn("concept");
        DateColumn date = new DateColumn("date");
        FloatColumn value = new FloatColumn("value");
        IntColumn patientId = new IntColumn("patient");
        t.addColumn(new Column[]{conceptId});
        t.addColumn(new Column[]{date});
        t.addColumn(new Column[]{value});
        t.addColumn(new Column[]{patientId});
        return t;
    }

    private static void generateTestData(Table t, int numberOfRecordsInTable, Stopwatch stopwatch) throws IOException {
        stopwatch.reset().start();
        System.out.println("Generating test data");
        TimeDependentFilteringTest.generateData(numberOfRecordsInTable, t);
        System.out.println("Time to generate " + numberOfRecordsInTable + " records: " + stopwatch.elapsed(TimeUnit.SECONDS) + " seconds");
    }

    private static void generateData(int observationCount, Table table) throws IOException {
        RandomStringGenerator generator = new RandomStringGenerator.Builder().withinRange(32, 127).build();
        while (concepts.size() <= 10) {
            concepts.add(generator.generate(30));
        }
        while (patientIds.size() <= 10000) {
            patientIds.add(RandomUtils.nextInt((int)0, (int)2000000000));
        }
        while (dates.size() <= size) {
            dates.add(PackedLocalDate.pack((LocalDate)TimeDependentFilteringTest.randomDate()));
        }
        DateColumn dateColumn = table.dateColumn("date");
        CategoryColumn conceptColumn = table.categoryColumn("concept");
        FloatColumn valueColumn = table.floatColumn("value");
        IntColumn patientColumn = table.intColumn("patient");
        for (int i = 0; i < observationCount; ++i) {
            dateColumn.append(dates.getInt(RandomUtils.nextInt((int)0, (int)dates.size())));
            conceptColumn.add(concepts.get(RandomUtils.nextInt((int)0, (int)concepts.size())));
            valueColumn.append(RandomUtils.nextFloat((float)0.0f, (float)100000.0f));
            patientColumn.append(patientIds.getInt(RandomUtils.nextInt((int)0, (int)patientIds.size())));
        }
    }

    private static LocalDate randomDate() {
        Random random = new Random();
        int minDay = (int)LocalDate.of(2000, 1, 1).toEpochDay();
        int maxDay = (int)LocalDate.of(2016, 1, 1).toEpochDay();
        long randomDay = minDay + random.nextInt(maxDay - minDay);
        return LocalDate.ofEpochDay(randomDay);
    }

    private static class IndependentResult {
        RangeSet<LocalDate> dateRanges = TreeRangeSet.create();

        private IndependentResult() {
        }

        void addRange(Range<LocalDate> dateRange) {
            this.dateRanges.add(dateRange);
        }
    }

    private static enum DependencyFilter {
        FIRST,
        LAST,
        ANY;

    }
}

