/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filters;

import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.filtering.datetimes.IsFirstDayOfTheMonth;
import tech.tablesaw.filtering.datetimes.IsInFebruary;
import tech.tablesaw.filtering.datetimes.IsInMarch;
import tech.tablesaw.filtering.datetimes.IsInYear;
import tech.tablesaw.filtering.datetimes.IsLastDayOfTheMonth;
import tech.tablesaw.filtering.datetimes.IsMonday;
import tech.tablesaw.filtering.datetimes.IsSunday;
import tech.tablesaw.util.Selection;

public class LocalDateFilterTest {
    private DateColumn localDateColumn = new DateColumn("testing");
    private Table table = Table.create((String)"test");

    @Before
    public void setUp() throws Exception {
        this.localDateColumn.append(LocalDate.of(2016, 2, 28));
        this.localDateColumn.append(LocalDate.of(2016, 2, 29));
        this.localDateColumn.append(LocalDate.of(2016, 3, 1));
        this.table.addColumn(new Column[]{this.localDateColumn});
    }

    @Test
    public void testIsSunday() {
        ColumnReference reference = new ColumnReference("testing");
        IsSunday isSunday = new IsSunday(reference);
        Selection selection = isSunday.apply(this.table);
        Assert.assertTrue((boolean)selection.contains(0));
        Assert.assertFalse((boolean)selection.contains(1));
        Assert.assertFalse((boolean)selection.contains(2));
    }

    @Test
    public void testIsMonday() {
        ColumnReference reference = new ColumnReference("testing");
        IsMonday isSunday = new IsMonday(reference);
        Selection selection = isSunday.apply(this.table);
        Assert.assertFalse((boolean)selection.contains(0));
        Assert.assertTrue((boolean)selection.contains(1));
        Assert.assertFalse((boolean)selection.contains(2));
    }

    @Test
    public void testIsFebruary() {
        ColumnReference reference = new ColumnReference("testing");
        IsInFebruary isFebruary = new IsInFebruary(reference);
        Selection selection = isFebruary.apply(this.table);
        Assert.assertTrue((boolean)selection.contains(0));
        Assert.assertTrue((boolean)selection.contains(1));
        Assert.assertFalse((boolean)selection.contains(2));
    }

    @Test
    public void testIsMarch() {
        ColumnReference reference = new ColumnReference("testing");
        IsInMarch result = new IsInMarch(reference);
        Selection selection = result.apply(this.table);
        Assert.assertFalse((boolean)selection.contains(0));
        Assert.assertFalse((boolean)selection.contains(1));
        Assert.assertTrue((boolean)selection.contains(2));
    }

    @Test
    public void testIsFirstDayOfTheMonth() {
        ColumnReference reference = new ColumnReference("testing");
        IsFirstDayOfTheMonth result = new IsFirstDayOfTheMonth(reference);
        Selection selection = result.apply(this.table);
        Assert.assertFalse((boolean)selection.contains(0));
        Assert.assertFalse((boolean)selection.contains(1));
        Assert.assertTrue((boolean)selection.contains(2));
    }

    @Test
    public void testIsLastDayOfTheMonth() {
        ColumnReference reference = new ColumnReference("testing");
        IsLastDayOfTheMonth result = new IsLastDayOfTheMonth(reference);
        Selection selection = result.apply(this.table);
        Assert.assertFalse((boolean)selection.contains(0));
        Assert.assertTrue((boolean)selection.contains(1));
        Assert.assertFalse((boolean)selection.contains(2));
    }

    @Test
    public void testIsInYear() {
        ColumnReference reference = new ColumnReference("testing");
        IsInYear result = new IsInYear(reference, 2016);
        Selection selection = result.apply(this.table);
        Assert.assertTrue((boolean)selection.contains(0));
        Assert.assertTrue((boolean)selection.contains(1));
        Assert.assertTrue((boolean)selection.contains(2));
        result = new IsInYear(reference, 2015);
        selection = result.apply(this.table);
        Assert.assertFalse((boolean)selection.contains(0));
        Assert.assertFalse((boolean)selection.contains(1));
        Assert.assertFalse((boolean)selection.contains(2));
    }
}

