/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.examples;

import it.unimi.dsi.fastutil.ints.IntIterator;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.QueryHelper;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.reducing.NumericSummaryTable;

public class ServiceExample {
    public static void main(String[] args) throws Exception {
        Table ops = Table.create((String)"../data/operations.csv");
        ServiceExample.out(ops.structure());
        ServiceExample.out(ops);
        DateTimeColumn start = ops.dateColumn("Date").atTime(ops.timeColumn("Start"));
        DateTimeColumn end = ops.dateColumn("Date").atTime(ops.timeColumn("End"));
        IntIterator intIterator = ops.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            if (!ops.timeColumn("End").get(row).isBefore(ops.timeColumn("Start").get(row))) continue;
            end.get(row).plusDays(1L);
        }
        LongColumn duration = start.differenceInSeconds(end);
        ops.addColumn(new Column[]{duration});
        duration.setName("Duration");
        ServiceExample.out(ops);
        Table q2_429_assembly = ops.selectWhere(QueryHelper.allOf((Filter[])new Filter[]{QueryHelper.column((String)"date").isInQ2(), QueryHelper.column((String)"SKU").startsWith("429"), QueryHelper.column((String)"Operation").isEqualTo("Assembly")}));
        NumericSummaryTable durationByFacilityAndShift = q2_429_assembly.median("Duration").by(new String[]{"Facility", "Shift"});
        ServiceExample.out(durationByFacilityAndShift);
        durationByFacilityAndShift.write().csv("/tmp/durationByFacilityAndShift.csv");
    }

    private static void out(Object obj) {
        System.out.println(String.valueOf(obj));
    }
}

