/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import java.time.LocalTime;
import java.time.temporal.ChronoField;
import org.junit.Assert;
import org.junit.Test;
import tech.tablesaw.columns.packeddata.PackedLocalDateTime;
import tech.tablesaw.columns.packeddata.PackedLocalTime;

public class PackedLocalTimeTest {
    @Test
    public void testGetHour() {
        LocalTime now = LocalTime.now();
        Assert.assertEquals((long)now.getHour(), (long)PackedLocalTime.getHour((int)PackedLocalTime.pack((LocalTime)now)));
    }

    @Test
    public void testGetMinute() {
        LocalTime now = LocalTime.now();
        Assert.assertEquals((long)now.getMinute(), (long)PackedLocalTime.getMinute((int)PackedLocalTime.pack((LocalTime)now)));
    }

    @Test
    public void testGetSecond() {
        LocalTime now = LocalTime.now();
        Assert.assertEquals((long)now.getSecond(), (long)PackedLocalTime.getSecond((int)PackedLocalTime.pack((LocalTime)now)));
    }

    @Test
    public void testGetSecondOfDay() {
        LocalTime now = LocalTime.now();
        Assert.assertEquals((long)now.get(ChronoField.SECOND_OF_DAY), (long)PackedLocalTime.getSecondOfDay((int)PackedLocalTime.pack((LocalTime)now)));
    }

    @Test
    public void testGetMinuteOfDay() {
        LocalTime now = LocalTime.now();
        Assert.assertEquals((long)now.get(ChronoField.MINUTE_OF_DAY), (long)PackedLocalTime.getMinuteOfDay((int)PackedLocalTime.pack((LocalTime)now)));
    }

    @Test
    public void testGetMillisecondOfDay() {
        LocalTime now = LocalTime.now();
        Assert.assertEquals((long)now.get(ChronoField.MILLI_OF_DAY), (long)PackedLocalTime.getMillisecondOfDay((int)PackedLocalTime.pack((LocalTime)now)));
    }

    @Test
    public void testPack() {
        LocalTime time = LocalTime.now();
        int packed = PackedLocalTime.pack((LocalTime)time);
        LocalTime t1 = PackedLocalTime.asLocalTime((int)PackedLocalDateTime.time((long)packed));
        Assert.assertNotNull((Object)t1);
        Assert.assertEquals((long)time.getHour(), (long)t1.getHour());
        Assert.assertEquals((long)time.getMinute(), (long)t1.getMinute());
        Assert.assertEquals((long)time.getSecond(), (long)t1.getSecond());
        Assert.assertEquals((long)time.get(ChronoField.MILLI_OF_SECOND), (long)t1.get(ChronoField.MILLI_OF_SECOND));
    }
}

