/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import org.junit.Assert;
import org.junit.Test;
import tech.tablesaw.columns.packeddata.PackedLocalDate;
import tech.tablesaw.columns.packeddata.PackedLocalDateTime;
import tech.tablesaw.columns.packeddata.PackedLocalTime;

public class PackedLocalDateTimeTest {
    @Test
    public void testGetDayOfMonth() {
        LocalDateTime today = LocalDateTime.now();
        Assert.assertEquals((long)today.getDayOfMonth(), (long)PackedLocalDateTime.getDayOfMonth((long)PackedLocalDateTime.pack((LocalDateTime)today)));
    }

    @Test
    public void testGetYear() {
        LocalDateTime today = LocalDateTime.now();
        Assert.assertEquals((long)today.getYear(), (long)PackedLocalDateTime.getYear((long)PackedLocalDateTime.pack((LocalDateTime)today)));
    }

    @Test
    public void testAsLocalDateTime() {
        LocalDateTime dateTime = LocalDateTime.now();
        long packed = PackedLocalDateTime.pack((LocalDate)dateTime.toLocalDate(), (LocalTime)dateTime.toLocalTime());
        LocalDateTime upacked = PackedLocalDateTime.asLocalDateTime((long)packed);
        Assert.assertEquals((long)dateTime.getDayOfYear(), (long)upacked.getDayOfYear());
        Assert.assertEquals((long)dateTime.getHour(), (long)upacked.getHour());
        Assert.assertEquals((long)dateTime.getMinute(), (long)upacked.getMinute());
        Assert.assertEquals((long)dateTime.getSecond(), (long)upacked.getSecond());
    }

    @Test
    public void testGetMonthValue() {
        long dateTime = PackedLocalDateTime.pack((LocalDate)LocalDate.of(2015, 12, 25), (LocalTime)LocalTime.now());
        Assert.assertEquals((long)12L, (long)PackedLocalDateTime.getMonthValue((long)dateTime));
    }

    @Test
    public void testPack() {
        LocalDate date = LocalDate.now();
        LocalTime time = LocalTime.now();
        long packed = PackedLocalDateTime.pack((LocalDate)date, (LocalTime)time);
        LocalDate d1 = PackedLocalDate.asLocalDate((int)PackedLocalDateTime.date((long)packed));
        LocalTime t1 = PackedLocalTime.asLocalTime((int)PackedLocalDateTime.time((long)packed));
        Assert.assertNotNull((Object)d1);
        Assert.assertNotNull((Object)t1);
        Assert.assertEquals((Object)date.toString(), (Object)d1.toString());
    }

    @Test
    public void testGetHour() {
        LocalDateTime now = LocalDateTime.now();
        Assert.assertEquals((long)now.getHour(), (long)PackedLocalDateTime.getHour((long)PackedLocalDateTime.pack((LocalDateTime)now)));
    }

    @Test
    public void testGetMinute() {
        LocalDateTime now = LocalDateTime.now();
        Assert.assertEquals((long)now.getMinute(), (long)PackedLocalDateTime.getMinute((long)PackedLocalDateTime.pack((LocalDateTime)now)));
    }

    @Test
    public void testGetSecond() {
        LocalDateTime now = LocalDateTime.now();
        Assert.assertEquals((long)now.getSecond(), (long)PackedLocalDateTime.getSecond((long)PackedLocalDateTime.pack((LocalDateTime)now)));
    }

    @Test
    public void testGetSecondOfDay() {
        LocalDateTime now = LocalDateTime.now();
        Assert.assertEquals((long)now.get(ChronoField.SECOND_OF_DAY), (long)PackedLocalDateTime.getSecondOfDay((long)PackedLocalDateTime.pack((LocalDateTime)now)));
    }

    @Test
    public void testGetMinuteOfDay() {
        LocalDateTime now = LocalDateTime.now();
        Assert.assertEquals((long)now.get(ChronoField.MINUTE_OF_DAY), (long)PackedLocalDateTime.getMinuteOfDay((long)PackedLocalDateTime.pack((LocalDateTime)now)));
    }

    @Test
    public void testGetMillisecondOfDay() {
        LocalDateTime now = LocalDateTime.now();
        Assert.assertEquals((long)now.get(ChronoField.MILLI_OF_DAY), (long)PackedLocalDateTime.getMillisecondOfDay((long)PackedLocalDateTime.pack((LocalDateTime)now)));
    }

    @Test
    public void testGetDayOfWeek() {
        LocalDateTime now = LocalDateTime.now();
        Assert.assertEquals((long)now.get(ChronoField.DAY_OF_WEEK), (long)PackedLocalDateTime.getDayOfWeek((long)PackedLocalDateTime.pack((LocalDateTime)now)).getValue());
    }
}

