/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.csv.CsvReadOptions;

public class ColumnTest {
    private static final ColumnType[] types = new ColumnType[]{ColumnType.LOCAL_DATE, ColumnType.INTEGER, ColumnType.CATEGORY};
    private Table table;

    @Before
    public void setUp() throws Exception {
        this.table = Table.read().csv(CsvReadOptions.builder((String)"../data/BushApproval.csv").columnTypes(types));
    }

    @Test
    public void testFirst() throws Exception {
        DateColumn first = (DateColumn)this.table.dateColumn("date").first(3);
        Assert.assertEquals((Object)LocalDate.parse("2004-02-04"), (Object)first.get(0));
        Assert.assertEquals((Object)LocalDate.parse("2004-01-21"), (Object)first.get(1));
        Assert.assertEquals((Object)LocalDate.parse("2004-01-07"), (Object)first.get(2));
        IntColumn first2 = (IntColumn)this.table.intColumn("approval").first(3);
        Assert.assertEquals((long)53L, (long)first2.get(0));
        Assert.assertEquals((long)53L, (long)first2.get(1));
        Assert.assertEquals((long)58L, (long)first2.get(2));
        CategoryColumn first3 = (CategoryColumn)this.table.categoryColumn("who").first(3);
        Assert.assertEquals((Object)"fox", (Object)first3.get(0));
        Assert.assertEquals((Object)"fox", (Object)first3.get(1));
        Assert.assertEquals((Object)"fox", (Object)first3.get(2));
    }

    @Test
    public void testLast() throws Exception {
        DateColumn last = (DateColumn)this.table.dateColumn("date").last(3);
        Assert.assertEquals((Object)LocalDate.parse("2001-03-27"), (Object)last.get(0));
        Assert.assertEquals((Object)LocalDate.parse("2001-02-27"), (Object)last.get(1));
        Assert.assertEquals((Object)LocalDate.parse("2001-02-09"), (Object)last.get(2));
        IntColumn last2 = (IntColumn)this.table.intColumn("approval").last(3);
        Assert.assertEquals((long)52L, (long)last2.get(0));
        Assert.assertEquals((long)53L, (long)last2.get(1));
        Assert.assertEquals((long)57L, (long)last2.get(2));
        CategoryColumn last3 = (CategoryColumn)this.table.categoryColumn("who").last(3);
        Assert.assertEquals((Object)"zogby", (Object)last3.get(0));
        Assert.assertEquals((Object)"zogby", (Object)last3.get(1));
        Assert.assertEquals((Object)"zogby", (Object)last3.get(2));
    }

    @Test
    public void testName() throws Exception {
        IntColumn c = this.table.intColumn("approval");
        Assert.assertEquals((Object)"approval", (Object)c.name());
    }

    @Test
    public void testComment() throws Exception {
        IntColumn c = this.table.intColumn("approval");
        c.setComment("Dumb comment");
        Assert.assertEquals((Object)"Dumb comment", (Object)c.comment());
    }

    @Test
    public void testType() throws Exception {
        IntColumn c = this.table.intColumn("approval");
        Assert.assertEquals((Object)ColumnType.INTEGER, (Object)c.type());
    }
}

