/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.ml.association;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.List;
import smile.association.ItemSet;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.ml.association.FrequentItemset;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.csv.CsvReadOptions;

public class FrequentItemsetExample {
    public static void main(String[] args) throws Exception {
        Table table = Table.read().csv(CsvReadOptions.builder((String)"../data/movielens.data").separator('\t'));
        FrequentItemsetExample.out(table.structure());
        FrequentItemsetExample.out(table.shape());
        ShortColumn movie = table.shortColumn("movie");
        CategoryColumn moviecat = new CategoryColumn("MovieCat");
        for (int i = 0; i < movie.size(); ++i) {
            moviecat.appendCell(movie.getString(i));
        }
        table.addColumn(new Column[]{moviecat});
        FrequentItemsetExample.out(table.shortColumn("user").unique().size());
        FrequentItemsetExample.out(table.shortColumn("movie").unique().size());
        FrequentItemset model = new FrequentItemset(table.shortColumn("user"), table.categoryColumn("MovieCat"), 0.24);
        List itemSetList = model.learn();
        FrequentItemsetExample.out("Frequent Itemsets");
        for (ItemSet itemSet : itemSetList) {
            if (itemSet.items.length != 2) continue;
            FrequentItemsetExample.out(itemSet);
        }
        FrequentItemsetExample.out(model.supportMap(250));
        Object2DoubleOpenHashMap confidenceMap = model.confidenceMap(0.9);
        Object2DoubleMap.FastEntrySet entrySet = confidenceMap.object2DoubleEntrySet();
        FrequentItemsetExample.out("");
        FrequentItemsetExample.out("Confidence Map");
        for (Object2DoubleMap.Entry entry : entrySet) {
            FrequentItemsetExample.out(entry.getKey() + " : " + entry.getDoubleValue());
        }
        Object2DoubleOpenHashMap confidenceMap2 = model.confidenceMap();
        Object2DoubleMap.FastEntrySet entrySet2 = confidenceMap2.object2DoubleEntrySet();
        FrequentItemsetExample.out("");
        FrequentItemsetExample.out("Confidence Map2");
        for (Object2DoubleMap.Entry entry2 : entrySet2) {
            FrequentItemsetExample.out(entry2.getKey() + " : " + entry2.getDoubleValue());
        }
    }

    private static void out(Object o) {
        System.out.println(String.valueOf(o));
    }
}

