/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.QueryHelper;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.filtering.IntPredicate;

public class IntColumnTest {
    private IntColumn intColumn;

    @Before
    public void setUp() throws Exception {
        this.intColumn = new IntColumn("t1");
    }

    @Test
    public void testSum() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(1);
        }
        Assert.assertEquals((long)100L, (long)this.intColumn.sum());
    }

    @Test
    public void testMin() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(i);
        }
        Assert.assertEquals((double)0.0, (double)this.intColumn.min(), (double)0.001);
    }

    @Test
    public void testMax() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(i);
        }
        Assert.assertEquals((double)99.0, (double)this.intColumn.max(), (double)0.001);
    }

    @Test
    public void testIsLessThan() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(i);
        }
        Assert.assertEquals((long)50L, (long)this.intColumn.isLessThan(50).size());
    }

    @Test
    public void testIsGreaterThan() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(i);
        }
        Assert.assertEquals((long)49L, (long)this.intColumn.isGreaterThan(50).size());
    }

    @Test
    public void testIsGreaterThanOrEqualTo() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(i);
        }
        Assert.assertEquals((long)50L, (long)this.intColumn.isGreaterThanOrEqualTo(50).size());
        Assert.assertEquals((long)50L, (long)this.intColumn.isGreaterThanOrEqualTo(50).get(0));
    }

    @Test
    public void testIsLessThanOrEqualTo() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(i);
        }
        Assert.assertEquals((long)51L, (long)this.intColumn.isLessThanOrEqualTo(50).size());
        Assert.assertEquals((long)49L, (long)this.intColumn.isLessThanOrEqualTo(50).get(49));
    }

    @Test
    public void testIsEqualTo() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(i);
        }
        Assert.assertEquals((long)1L, (long)this.intColumn.isEqualTo(10).size());
    }

    @Test
    public void testPercents() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(i);
        }
        FloatColumn floatColumn = this.intColumn.asRatio();
        Assert.assertEquals((double)1.0, (double)floatColumn.sum(), (double)0.1);
    }

    @Test
    public void testSelectIf() {
        for (int i = 0; i < 100; ++i) {
            this.intColumn.append(i);
        }
        IntPredicate predicate = value -> value < 10;
        IntColumn column1 = this.intColumn.selectIf(predicate);
        Assert.assertEquals((long)10L, (long)column1.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((column1.get(i) < 10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSelect() {
        int i;
        for (int i2 = 0; i2 < 100; ++i2) {
            this.intColumn.append(i2);
        }
        IntPredicate predicate = value -> value < 10;
        IntColumn column1 = this.intColumn.selectIf(predicate);
        Assert.assertEquals((long)10L, (long)column1.size());
        IntColumn column2 = this.intColumn.select(this.intColumn.select(predicate));
        Assert.assertEquals((long)10L, (long)column2.size());
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((column1.get(i) < 10 ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((column2.get(i) < 10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDifference() {
        int[] originalValues = new int[]{32, 42, 40, 57, 52};
        int[] expectedValues = new int[]{IntColumn.MISSING_VALUE, 10, -2, 17, -5};
        IntColumn initial = new IntColumn("Test", originalValues.length);
        for (int value : originalValues) {
            initial.append(value);
        }
        IntColumn difference = initial.difference();
        Assert.assertEquals((String)"Both sets of data should be the same size.", (long)expectedValues.length, (long)difference.size());
        for (int index = 0; index < difference.size(); ++index) {
            int actual = difference.get(index);
            Assert.assertEquals((String)("difference operation at index:" + index + " failed"), (long)expectedValues[index], (long)actual);
        }
    }

    @Test
    public void testIntIsIn() {
        int[] originalValues = new int[]{32, 42, 40, 57, 52, -2};
        int[] inValues = new int[]{10, -2, 57, -5};
        IntColumn inColumn = new IntColumn("In", new IntArrayList(inValues));
        IntColumn initial = new IntColumn("Test", originalValues.length);
        Table t = Table.create((String)"t", (Column[])new Column[]{initial});
        for (int value : originalValues) {
            initial.append(value);
        }
        Filter filter = QueryHelper.column((String)"Test").isIn(inColumn);
        Table result = t.selectWhere(filter);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testDivide() {
        int[] originalValues = new int[]{32, 42, 40, 57, 52, -2};
        IntColumn originals = new IntColumn("Originals", new IntArrayList(originalValues));
        FloatColumn divided = originals.divide(3);
        Assert.assertEquals((long)originals.size(), (long)divided.size());
    }

    @Test
    public void testDivide2() {
        int[] originalValues = new int[]{32, 42, 40, 57, 52, -2};
        IntColumn originals = new IntColumn("Originals", new IntArrayList(originalValues));
        FloatColumn divided = originals.divide(3.3);
        Assert.assertEquals((long)originals.size(), (long)divided.size());
    }
}

