/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Stopwatch;
import io.codearte.jfairy.Fairy;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.stat.StatUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.util.Selection;

public class FloatColumnTest {
    @Ignore
    @Test
    public void testApplyFilter() {
        Fairy fairy = Fairy.create();
        fairy.baseProducer().trueOrFalse();
        Table table = Table.create((String)"t");
        FloatColumn floatColumn = new FloatColumn("test", 1000000000);
        BooleanColumn booleanColumn = new BooleanColumn("bools", 1000000000);
        table.addColumn(new Column[]{floatColumn});
        table.addColumn(new Column[]{booleanColumn});
        for (int i = 0; i < 1000000000; ++i) {
            floatColumn.append((float)Math.random());
            booleanColumn.append(fairy.baseProducer().trueOrFalse());
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        table.sortOn(new String[]{"test"});
        System.out.println("Sort time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
        stopwatch.reset().start();
        System.out.println(floatColumn.summary());
        stopwatch.reset().start();
        floatColumn.isLessThan(0.5f);
        System.out.println("Search time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Ignore
    @Test
    public void testSortAndApplyFilter1() {
        FloatColumn floatColumn = new FloatColumn("test", 1000000000);
        for (int i = 0; i < 1000000000; ++i) {
            floatColumn.append((float)Math.random());
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        System.out.println(floatColumn.sum());
        System.out.println(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        stopwatch.reset().start();
        floatColumn.sortAscending();
        System.out.println("Sort time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
        stopwatch.reset().start();
        floatColumn.isLessThan(0.5f);
        System.out.println("Search time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Ignore
    @Test
    public void testSort1() throws Exception {
        FloatColumn floatColumn = new FloatColumn("test", 1000000000);
        System.out.println("Adding floats to column");
        for (int i = 0; i < 1000000000; ++i) {
            floatColumn.append((float)Math.random());
        }
        System.out.println("Sorting");
        Stopwatch stopwatch = Stopwatch.createStarted();
        floatColumn.sortAscending();
        System.out.println("Sort time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Test
    public void testIsLessThan() {
        int size = 1000000;
        Table table = Table.create((String)"t");
        FloatColumn floatColumn = new FloatColumn("test", size);
        table.addColumn(new Column[]{floatColumn});
        for (int i = 0; i < size; ++i) {
            floatColumn.append((float)Math.random());
        }
        Selection results = floatColumn.isLessThan(0.5f);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            if (!results.contains(i)) continue;
            ++count;
        }
        Assert.assertTrue((count < 575000 ? 1 : 0) != 0);
        Assert.assertTrue((count > 425000 ? 1 : 0) != 0);
    }

    @Test
    public void testIsGreaterThan() {
        int size = 1000000;
        Table table = Table.create((String)"t");
        FloatColumn floatColumn = new FloatColumn("test", size);
        table.addColumn(new Column[]{floatColumn});
        for (int i = 0; i < size; ++i) {
            floatColumn.append((float)Math.random());
        }
        Selection results = floatColumn.isGreaterThan(0.5f);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            if (!results.contains(i)) continue;
            ++count;
        }
        Assert.assertTrue((count < 575000 ? 1 : 0) != 0);
        Assert.assertTrue((count > 425000 ? 1 : 0) != 0);
    }

    @Test
    public void testSort() {
        float n;
        int records = 1000000;
        FloatColumn floatColumn = new FloatColumn("test", records);
        for (int i = 0; i < records; ++i) {
            floatColumn.append((float)Math.random());
        }
        floatColumn.sortAscending();
        float last = Float.NEGATIVE_INFINITY;
        FloatIterator floatIterator = floatColumn.iterator();
        while (floatIterator.hasNext()) {
            n = ((Float)floatIterator.next()).floatValue();
            Assert.assertTrue((n >= last ? 1 : 0) != 0);
            last = n;
        }
        floatColumn.sortDescending();
        last = Float.POSITIVE_INFINITY;
        floatIterator = floatColumn.iterator();
        while (floatIterator.hasNext()) {
            n = ((Float)floatIterator.next()).floatValue();
            Assert.assertTrue((n <= last ? 1 : 0) != 0);
            last = n;
        }
        records = 10;
        floatColumn = new FloatColumn("test", records);
        for (int i = 0; i < records; ++i) {
            floatColumn.append((float)Math.random());
        }
        floatColumn.sortDescending();
        last = Float.POSITIVE_INFINITY;
        FloatIterator floatIterator2 = floatColumn.iterator();
        while (floatIterator2.hasNext()) {
            n = ((Float)floatIterator2.next()).floatValue();
            Assert.assertTrue((n <= last ? 1 : 0) != 0);
            last = n;
        }
    }

    @Test
    public void testIsEqualTo() {
        Table table = Table.create((String)"t");
        FloatColumn floatColumn = new FloatColumn("test", 1000000);
        float[] floats = new float[1000000];
        table.addColumn(new Column[]{floatColumn});
        for (int i = 0; i < 1000000; ++i) {
            float f = (float)Math.random();
            floatColumn.append(f);
            floats[i] = f;
        }
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator();
        for (int i = 0; i < 100; ++i) {
            float f = floats[randomDataGenerator.nextInt(0, 999999)];
            Selection results = floatColumn.isEqualTo(f);
            Assert.assertEquals((double)f, (double)floatColumn.get(results.iterator().nextInt()), (double)0.001);
        }
    }

    @Test
    public void testMaxAndMin() {
        int i;
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i2 = 0; i2 < 100; ++i2) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatArrayList floats1 = floats.top(50);
        FloatArrayList floats2 = floats.bottom(50);
        double[] doubles1 = new double[50];
        double[] doubles2 = new double[50];
        for (i = 0; i < floats1.size(); ++i) {
            doubles1[i] = floats1.getFloat(i);
        }
        for (i = 0; i < floats2.size(); ++i) {
            doubles2[i] = floats2.getFloat(i);
        }
        Assert.assertTrue((StatUtils.min((double[])doubles1) >= StatUtils.max((double[])doubles2) ? 1 : 0) != 0);
    }

    @Test
    public void testRound() {
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatColumn newFloats = floats.round();
        Assert.assertFalse((boolean)newFloats.isEmpty());
    }

    @Test
    public void testLogN() {
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatColumn newFloats = floats.logN();
        Assert.assertFalse((boolean)newFloats.isEmpty());
    }

    @Test
    public void testLog10() {
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatColumn newFloats = floats.log10();
        Assert.assertFalse((boolean)newFloats.isEmpty());
    }

    @Test
    public void testLog1p() {
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatColumn newFloats = floats.log1p();
        Assert.assertFalse((boolean)newFloats.isEmpty());
    }

    @Test
    public void testAbs() {
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatColumn newFloats = floats.abs();
        Assert.assertFalse((boolean)newFloats.isEmpty());
    }

    @Test
    public void testClear() {
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        Assert.assertFalse((boolean)floats.isEmpty());
        floats.clear();
        Assert.assertTrue((boolean)floats.isEmpty());
    }

    @Test
    public void testCountMissing() {
        int i;
        FloatColumn floats = new FloatColumn("floats", 10);
        for (i = 0; i < 10; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)1000.0f));
        }
        Assert.assertEquals((long)0L, (long)floats.countMissing());
        floats.clear();
        for (i = 0; i < 10; ++i) {
            floats.append(FloatColumn.MISSING_VALUE);
        }
        Assert.assertEquals((long)10L, (long)floats.countMissing());
    }

    @Test
    public void testCountUnique() {
        float[] notUniques;
        float[] uniques;
        FloatColumn floats = new FloatColumn("floats", 10);
        for (float unique : uniques = new float[]{0.0f, 1.0E-8f, -1.0E-6f, 92923.3f, 24252.0f, 23442.0f, 2252.0f, 2342.0f}) {
            floats.append(unique);
        }
        Assert.assertEquals((long)uniques.length, (long)floats.countUnique());
        floats.clear();
        for (float notUnique : notUniques = new float[]{0.0f, 1.0E-8f, -1.0E-6f, 92923.3f, 24252.0f, 23442.0f, 2252.0f, 2342.0f, 0.0f}) {
            floats.append(notUnique);
        }
        Assert.assertEquals((long)(notUniques.length - 1), (long)floats.countUnique());
    }

    @Test
    public void testUnique() {
        float[] notUniques;
        float[] uniques;
        FloatColumn floats = new FloatColumn("floats", 10);
        for (float unique : uniques = new float[]{0.0f, 1.0E-8f, -1.0E-6f, 92923.3f, 24252.0f, 23442.0f, 2252.0f, 2342.0f}) {
            floats.append(unique);
        }
        Assert.assertEquals((long)uniques.length, (long)floats.unique().size());
        floats.clear();
        for (float notUnique : notUniques = new float[]{0.0f, 1.0E-8f, -1.0E-6f, 92923.3f, 24252.0f, 23442.0f, 2252.0f, 2342.0f, 0.0f}) {
            floats.append(notUnique);
        }
        Assert.assertEquals((long)(notUniques.length - 1), (long)floats.unique().size());
    }

    @Test
    public void testIsMissingAndIsNotMissing() {
        int i;
        FloatColumn floats = new FloatColumn("floats", 10);
        for (i = 0; i < 10; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)1000.0f));
        }
        Assert.assertEquals((long)0L, (long)floats.isMissing().size());
        Assert.assertEquals((long)10L, (long)floats.isNotMissing().size());
        floats.clear();
        for (i = 0; i < 10; ++i) {
            floats.append(FloatColumn.MISSING_VALUE);
        }
        Assert.assertEquals((long)10L, (long)floats.isMissing().size());
        Assert.assertEquals((long)0L, (long)floats.isNotMissing().size());
    }

    @Test
    public void testEmptyCopy() {
        FloatColumn floats = new FloatColumn("floats", 100);
        String comment = "This is a comment";
        floats.setComment(comment);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatColumn empty = floats.emptyCopy();
        Assert.assertTrue((boolean)empty.isEmpty());
        Assert.assertEquals((Object)floats.name(), (Object)empty.name());
    }

    @Test
    public void testSize() {
        int size = 100;
        FloatColumn floats = new FloatColumn("floats", size);
        Assert.assertEquals((long)0L, (long)floats.size());
        for (int i = 0; i < size; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        Assert.assertEquals((long)size, (long)floats.size());
        floats.clear();
        Assert.assertEquals((long)0L, (long)floats.size());
    }

    @Test
    public void testNeg() {
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatColumn newFloats = floats.neg();
        Assert.assertFalse((boolean)newFloats.isEmpty());
    }

    @Test
    public void tesMod() {
        FloatColumn floats = new FloatColumn("floats", 100);
        FloatColumn otherFloats = new FloatColumn("otherFloats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
            otherFloats.append(floats.get(i) - 1.0f);
        }
        FloatColumn newFloats = floats.remainder(otherFloats);
        Assert.assertFalse((boolean)newFloats.isEmpty());
    }

    @Test
    public void testSquareAndSqrt() {
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatColumn newFloats = floats.square();
        FloatColumn revert = newFloats.sqrt();
        for (int i = 0; i < floats.size(); ++i) {
            Assert.assertEquals((double)floats.get(i), (double)revert.get(i), (double)0.01);
        }
    }

    @Test
    public void testType() {
        FloatColumn floats = new FloatColumn("floats", 100);
        Assert.assertEquals((Object)ColumnType.FLOAT, (Object)floats.type());
    }

    @Test
    public void testCubeAndCbrt() {
        FloatColumn floats = new FloatColumn("floats", 100);
        for (int i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
        }
        FloatColumn newFloats = floats.cube();
        FloatColumn revert = newFloats.cubeRoot();
        for (int i = 0; i < floats.size(); ++i) {
            Assert.assertEquals((double)floats.get(i), (double)revert.get(i), (double)0.01);
        }
    }

    @Test
    public void testDifference() {
        int i;
        FloatColumn floats = new FloatColumn("floats", 100);
        FloatColumn otherFloats = new FloatColumn("otherFloats", 100);
        for (i = 0; i < 100; ++i) {
            floats.append(RandomUtils.nextFloat((float)0.0f, (float)10000.0f));
            otherFloats.append(floats.get(i) - 1.0f);
        }
        for (i = 0; i < floats.size(); ++i) {
            Assert.assertEquals((double)floats.get(i), (double)((double)otherFloats.get(i) + 1.0), (double)0.01);
        }
    }

    @Test
    public void testDifferencePositive() {
        float[] originalValues = new float[]{32.0f, 42.0f, 40.0f, 57.0f, 52.0f};
        float[] expectedValues = new float[]{Float.NaN, 10.0f, -2.0f, 17.0f, -5.0f};
        FloatColumn initial = new FloatColumn("Test", originalValues.length);
        for (float value : originalValues) {
            initial.append(value);
        }
        FloatColumn difference = initial.difference();
        Assert.assertEquals((String)"Both sets of data should be the same size.", (long)expectedValues.length, (long)difference.size());
        for (int index = 0; index < difference.size(); ++index) {
            float actual = difference.get(index);
            if (index == 0) {
                Assert.assertTrue((String)("difference operation at index:" + index + " failed"), (boolean)Float.isNaN(actual));
                continue;
            }
            Assert.assertEquals((String)("difference operation at index:" + index + " failed"), (float)expectedValues[index], (float)actual, (float)0.0f);
        }
    }

    @Test
    public void testDifferenceNegative() {
        float[] originalValues = new float[]{32.0f, 42.0f, 40.0f, 57.0f, 52.0f};
        float[] expectedValues = new float[]{Float.MAX_VALUE, Float.MIN_VALUE, -12.0f, 117.0f, 5.0f};
        FloatColumn initial = new FloatColumn("Test", originalValues.length);
        for (float value : originalValues) {
            initial.append(value);
        }
        FloatColumn difference = initial.difference();
        Assert.assertEquals((String)"Both sets of data should be the same size.", (long)expectedValues.length, (long)difference.size());
        for (int index = 0; index < difference.size(); ++index) {
            float actual = difference.get(index);
            if (index == 0) {
                Assert.assertTrue((String)("difference operation at index:" + index + " failed"), (boolean)Float.isNaN(actual));
                continue;
            }
            Assert.assertNotEquals((String)("difference operation at index:" + index + " failed"), (double)expectedValues[index], (double)actual, (double)0.0);
        }
    }
}

