/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Stopwatch;
import io.codearte.jfairy.Fairy;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.stat.StatUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.util.Selection;

public class DoubleColumnTest {
    @Ignore
    @Test
    public void testApplyFilter() {
        Fairy fairy = Fairy.create();
        fairy.baseProducer().trueOrFalse();
        Table table = Table.create((String)"t");
        DoubleColumn doubleColumn = new DoubleColumn("test", 1000000000);
        BooleanColumn booleanColumn = new BooleanColumn("bools", 1000000000);
        table.addColumn(new Column[]{doubleColumn});
        table.addColumn(new Column[]{booleanColumn});
        for (int i = 0; i < 1000000000; ++i) {
            doubleColumn.append(Math.random());
            booleanColumn.append(fairy.baseProducer().trueOrFalse());
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        table.sortOn(new String[]{"test"});
        System.out.println("Sort time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
        stopwatch.reset().start();
        System.out.println(doubleColumn.summary());
        stopwatch.reset().start();
        doubleColumn.isLessThan(0.5);
        System.out.println("Search time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Ignore
    @Test
    public void testSortAndApplyFilter1() {
        DoubleColumn doubleColumn = new DoubleColumn("test", 1000000000);
        for (int i = 0; i < 1000000000; ++i) {
            doubleColumn.append(Math.random());
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        System.out.println(doubleColumn.sum());
        System.out.println(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        stopwatch.reset().start();
        doubleColumn.sortAscending();
        System.out.println("Sort time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
        stopwatch.reset().start();
        doubleColumn.isLessThan(0.5);
        System.out.println("Search time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Ignore
    @Test
    public void testSort1() throws Exception {
        DoubleColumn doubleColumn = new DoubleColumn("test", 1000000000);
        System.out.println("Adding doubles to column");
        for (int i = 0; i < 1000000000; ++i) {
            doubleColumn.append(Math.random());
        }
        System.out.println("Sorting");
        Stopwatch stopwatch = Stopwatch.createStarted();
        doubleColumn.sortAscending();
        System.out.println("Sort time in ms = " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Test
    public void testIsLessThan() {
        int size = 1000000;
        Table table = Table.create((String)"t");
        DoubleColumn doubleColumn = new DoubleColumn("test", size);
        table.addColumn(new Column[]{doubleColumn});
        for (int i = 0; i < size; ++i) {
            doubleColumn.append(Math.random());
        }
        Selection results = doubleColumn.isLessThan(0.5);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            if (!results.contains(i)) continue;
            ++count;
        }
        Assert.assertTrue((count < 575000 ? 1 : 0) != 0);
        Assert.assertTrue((count > 425000 ? 1 : 0) != 0);
    }

    @Test
    public void testIsGreaterThan() {
        int size = 1000000;
        Table table = Table.create((String)"t");
        DoubleColumn doubleColumn = new DoubleColumn("test", size);
        table.addColumn(new Column[]{doubleColumn});
        for (int i = 0; i < size; ++i) {
            doubleColumn.append(Math.random());
        }
        Selection results = doubleColumn.isGreaterThan(0.5);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            if (!results.contains(i)) continue;
            ++count;
        }
        Assert.assertTrue((count < 575000 ? 1 : 0) != 0);
        Assert.assertTrue((count > 425000 ? 1 : 0) != 0);
    }

    @Test
    public void testSort() {
        double n;
        int records = 1000000;
        DoubleColumn doubleColumn = new DoubleColumn("test", records);
        for (int i = 0; i < records; ++i) {
            doubleColumn.append(Math.random());
        }
        doubleColumn.sortAscending();
        double last = Double.NEGATIVE_INFINITY;
        DoubleIterator doubleIterator = doubleColumn.iterator();
        while (doubleIterator.hasNext()) {
            n = (Double)doubleIterator.next();
            Assert.assertTrue((n >= last ? 1 : 0) != 0);
            last = n;
        }
        doubleColumn.sortDescending();
        last = Double.POSITIVE_INFINITY;
        doubleIterator = doubleColumn.iterator();
        while (doubleIterator.hasNext()) {
            n = (Double)doubleIterator.next();
            Assert.assertTrue((n <= last ? 1 : 0) != 0);
            last = n;
        }
        records = 10;
        doubleColumn = new DoubleColumn("test", records);
        for (int i = 0; i < records; ++i) {
            doubleColumn.append(Math.random());
        }
        doubleColumn.sortDescending();
        last = Double.POSITIVE_INFINITY;
        DoubleIterator doubleIterator2 = doubleColumn.iterator();
        while (doubleIterator2.hasNext()) {
            n = (Double)doubleIterator2.next();
            Assert.assertTrue((n <= last ? 1 : 0) != 0);
            last = n;
        }
    }

    @Test
    public void testIsEqualTo() {
        Table table = Table.create((String)"t");
        DoubleColumn doubleColumn = new DoubleColumn("test", 1000000);
        double[] doubles = new double[1000000];
        table.addColumn(new Column[]{doubleColumn});
        for (int i = 0; i < 1000000; ++i) {
            double d = Math.random();
            doubleColumn.append(d);
            doubles[i] = d;
        }
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator();
        for (int i = 0; i < 100; ++i) {
            double aDouble = doubles[randomDataGenerator.nextInt(0, 999999)];
            Selection results = doubleColumn.isEqualTo(aDouble);
            Assert.assertEquals((double)aDouble, (double)doubleColumn.get(results.iterator().nextInt()), (double)0.001);
        }
    }

    @Test
    public void testMaxAndMin() {
        int i;
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i2 = 0; i2 < 100; ++i2) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleArrayList doubles1 = doubles.top(50);
        DoubleArrayList doubles2 = doubles.bottom(50);
        double[] doublesA = new double[50];
        double[] doublesB = new double[50];
        for (i = 0; i < doubles1.size(); ++i) {
            doublesA[i] = doubles1.getDouble(i);
        }
        for (i = 0; i < doubles2.size(); ++i) {
            doublesB[i] = doubles2.getDouble(i);
        }
        Assert.assertTrue((StatUtils.min((double[])doublesA) >= StatUtils.max((double[])doublesB) ? 1 : 0) != 0);
    }

    @Test
    public void testRound() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleColumn newDoubles = doubles.round();
        Assert.assertFalse((boolean)newDoubles.isEmpty());
    }

    @Test
    public void testLogN() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleColumn newDoubles = doubles.logN();
        Assert.assertFalse((boolean)newDoubles.isEmpty());
    }

    @Test
    public void testLog10() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleColumn newDoubles = doubles.log10();
        Assert.assertFalse((boolean)newDoubles.isEmpty());
    }

    @Test
    public void testLog1p() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleColumn newDoubles = doubles.log1p();
        Assert.assertFalse((boolean)newDoubles.isEmpty());
    }

    @Test
    public void testAbs() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleColumn newDoubles = doubles.abs();
        Assert.assertFalse((boolean)newDoubles.isEmpty());
    }

    @Test
    public void testClear() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        Assert.assertFalse((boolean)doubles.isEmpty());
        doubles.clear();
        Assert.assertTrue((boolean)doubles.isEmpty());
    }

    @Test
    public void testCountMissing() {
        int i;
        DoubleColumn doubles = new DoubleColumn("doubles", 10);
        for (i = 0; i < 10; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)1000.0));
        }
        Assert.assertEquals((long)0L, (long)doubles.countMissing());
        doubles.clear();
        for (i = 0; i < 10; ++i) {
            doubles.append(DoubleColumn.MISSING_VALUE);
        }
        Assert.assertEquals((long)10L, (long)doubles.countMissing());
    }

    @Test
    public void testCountUnique() {
        double[] notUniques;
        double[] uniques;
        DoubleColumn doubles = new DoubleColumn("doubles", 10);
        for (double unique : uniques = new double[]{0.0, 1.0E-8f, -1.0E-6f, 92923.296875, 24252.0, 23442.0, 2252.0, 2342.0}) {
            doubles.append(unique);
        }
        Assert.assertEquals((long)uniques.length, (long)doubles.countUnique());
        doubles.clear();
        for (double notUnique : notUniques = new double[]{0.0, 1.0E-8f, -1.0E-6f, 92923.296875, 24252.0, 23442.0, 2252.0, 2342.0, 0.0}) {
            doubles.append(notUnique);
        }
        Assert.assertEquals((long)(notUniques.length - 1), (long)doubles.countUnique());
    }

    @Test
    public void testUnique() {
        double[] notUniques;
        double[] uniques;
        DoubleColumn doubles = new DoubleColumn("doubles", 10);
        for (double unique : uniques = new double[]{0.0, 1.0E-8f, -1.0E-6f, 92923.296875, 24252.0, 23442.0, 2252.0, 2342.0}) {
            doubles.append(unique);
        }
        Assert.assertEquals((long)uniques.length, (long)doubles.unique().size());
        doubles.clear();
        for (double notUnique : notUniques = new double[]{0.0, 1.0E-8f, -1.0E-6f, 92923.296875, 24252.0, 23442.0, 2252.0, 2342.0, 0.0}) {
            doubles.append(notUnique);
        }
        Assert.assertEquals((long)(notUniques.length - 1), (long)doubles.unique().size());
    }

    @Test
    public void testIsMissingAndIsNotMissing() {
        int i;
        DoubleColumn doubles = new DoubleColumn("doubles", 10);
        for (i = 0; i < 10; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)1000.0));
        }
        Assert.assertEquals((long)0L, (long)doubles.isMissing().size());
        Assert.assertEquals((long)10L, (long)doubles.isNotMissing().size());
        doubles.clear();
        for (i = 0; i < 10; ++i) {
            doubles.append(DoubleColumn.MISSING_VALUE);
        }
        Assert.assertEquals((long)10L, (long)doubles.isMissing().size());
        Assert.assertEquals((long)0L, (long)doubles.isNotMissing().size());
    }

    @Test
    public void testEmptyCopy() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        String comment = "This is a comment";
        doubles.setComment(comment);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleColumn empty = doubles.emptyCopy();
        Assert.assertTrue((boolean)empty.isEmpty());
        Assert.assertEquals((Object)doubles.name(), (Object)empty.name());
    }

    @Test
    public void testSize() {
        int size = 100;
        DoubleColumn doubles = new DoubleColumn("doubles", size);
        Assert.assertEquals((long)0L, (long)doubles.size());
        for (int i = 0; i < size; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        Assert.assertEquals((long)size, (long)doubles.size());
        doubles.clear();
        Assert.assertEquals((long)0L, (long)doubles.size());
    }

    @Test
    public void testNeg() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleColumn newDoubles = doubles.neg();
        Assert.assertFalse((boolean)newDoubles.isEmpty());
    }

    @Test
    public void tesMod() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        DoubleColumn otherDoubles = new DoubleColumn("otherDoubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
            otherDoubles.append(doubles.get(i) - 1.0);
        }
        DoubleColumn newDoubles = doubles.remainder(otherDoubles);
        Assert.assertFalse((boolean)newDoubles.isEmpty());
    }

    @Test
    public void testSquareAndSqrt() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleColumn newDoubles = doubles.square();
        DoubleColumn revert = newDoubles.sqrt();
        for (int i = 0; i < doubles.size(); ++i) {
            Assert.assertEquals((double)doubles.get(i), (double)revert.get(i), (double)0.01);
        }
    }

    @Test
    public void testType() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)doubles.type());
    }

    @Test
    public void testCubeAndCbrt() {
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        for (int i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
        }
        DoubleColumn newDoubles = doubles.cube();
        DoubleColumn revert = newDoubles.cubeRoot();
        for (int i = 0; i < doubles.size(); ++i) {
            Assert.assertEquals((double)doubles.get(i), (double)revert.get(i), (double)0.01);
        }
    }

    @Test
    public void testDifference() {
        int i;
        DoubleColumn doubles = new DoubleColumn("doubles", 100);
        DoubleColumn otherDoubles = new DoubleColumn("otherDoubles", 100);
        for (i = 0; i < 100; ++i) {
            doubles.append(RandomUtils.nextDouble((double)0.0, (double)10000.0));
            otherDoubles.append(doubles.get(i) - 1.0);
        }
        for (i = 0; i < doubles.size(); ++i) {
            Assert.assertEquals((double)doubles.get(i), (double)(otherDoubles.get(i) + 1.0), (double)0.01);
        }
    }

    @Test
    public void testDifferencePositive() {
        double[] originalValues = new double[]{32.0, 42.0, 40.0, 57.0, 52.0};
        double[] expectedValues = new double[]{Double.NaN, 10.0, -2.0, 17.0, -5.0};
        DoubleColumn initial = new DoubleColumn("Test", originalValues.length);
        for (double value : originalValues) {
            initial.append(value);
        }
        DoubleColumn difference = initial.difference();
        Assert.assertEquals((String)"Both sets of data should be the same size.", (long)expectedValues.length, (long)difference.size());
        for (int index = 0; index < difference.size(); ++index) {
            double actual = difference.get(index);
            if (index == 0) {
                Assert.assertTrue((String)("difference operation at index:" + index + " failed"), (boolean)Double.isNaN(actual));
                continue;
            }
            Assert.assertEquals((String)("difference operation at index:" + index + " failed"), (double)expectedValues[index], (double)actual, (double)0.0);
        }
    }

    @Test
    public void testDifferenceNegative() {
        double[] originalValues = new double[]{32.0, 42.0, 40.0, 57.0, 52.0};
        double[] expectedValues = new double[]{Double.MAX_VALUE, Double.MIN_VALUE, -12.0, 117.0, 5.0};
        DoubleColumn initial = new DoubleColumn("Test", originalValues.length);
        for (double value : originalValues) {
            initial.append(value);
        }
        DoubleColumn difference = initial.difference();
        Assert.assertEquals((String)"Both sets of data should be the same size.", (long)expectedValues.length, (long)difference.size());
        for (int index = 0; index < difference.size(); ++index) {
            double actual = difference.get(index);
            if (index == 0) {
                Assert.assertTrue((String)("difference operation at index:" + index + " failed"), (boolean)Double.isNaN(actual));
                continue;
            }
            Assert.assertNotEquals((String)("difference operation at index:" + index + " failed"), (double)expectedValues[index], (double)actual, (double)0.0);
        }
    }
}

