/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import java.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.QueryHelper;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class DateTimeColumnTest {
    private DateTimeColumn column1;

    @Before
    public void setUp() throws Exception {
        Table table = Table.create((String)"Test");
        this.column1 = new DateTimeColumn("Game date");
        table.addColumn(new Column[]{this.column1});
    }

    @Test
    public void testAppendCell() throws Exception {
        this.column1.appendCell("1923-10-20T10:15:30");
        this.column1.appendCell("1924-12-10T10:15:30");
        this.column1.appendCell("2015-12-05T10:15:30");
        this.column1.appendCell("2015-12-20T10:15:30");
        Assert.assertEquals((long)4L, (long)this.column1.size());
        LocalDateTime date = LocalDateTime.now();
        this.column1.append(date);
        Assert.assertEquals((long)5L, (long)this.column1.size());
    }

    @Test
    public void testConvertMillisSinceEpoch() throws Exception {
        long millis = 1503952123189L;
        this.column1.appendCell(Long.toString(millis));
        Assert.assertEquals((long)1L, (long)this.column1.size());
        Assert.assertEquals((long)2017L, (long)this.column1.get(0).getYear());
        Assert.assertEquals((long)8L, (long)this.column1.get(0).getMonthValue());
        Assert.assertEquals((long)28L, (long)this.column1.get(0).getDayOfMonth());
        Assert.assertEquals((long)20L, (long)this.column1.get(0).getHour());
        long[] millisArr = this.column1.toEpochMillisArray();
        Assert.assertEquals((long)1L, (long)millisArr.length);
        Assert.assertEquals((long)millis, (long)millisArr[0]);
    }

    @Test
    public void testAfter() throws Exception {
        Table t = Table.create((String)"test");
        t.addColumn(new Column[]{this.column1});
        this.column1.appendCell("2015-12-03T10:15:30");
        this.column1.appendCell("2015-01-03T10:15:30");
        Table result = t.selectWhere(QueryHelper.column((String)"Game date").isAfter(LocalDateTime.of(2015, 2, 2, 0, 0)));
        Assert.assertEquals((long)result.rowCount(), (long)1L);
    }
}

