/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class DateColumnTest {
    private DateColumn column1;

    @Before
    public void setUp() throws Exception {
        Table table = Table.create((String)"Test");
        this.column1 = new DateColumn("Game date");
        table.addColumn(new Column[]{this.column1});
    }

    @Test
    public void testAddCell() throws Exception {
        this.column1.appendCell("2013-10-23");
        this.column1.appendCell("12/23/1924");
        this.column1.appendCell("12-May-2015");
        this.column1.appendCell("12-Jan-2015");
        Assert.assertEquals((long)4L, (long)this.column1.size());
        LocalDate date = LocalDate.now();
        this.column1.append(date);
        Assert.assertEquals((long)5L, (long)this.column1.size());
    }

    @Test
    public void testDayOfMonth() throws Exception {
        this.column1.appendCell("2013-10-23");
        this.column1.appendCell("12/24/1924");
        this.column1.appendCell("12-May-2015");
        this.column1.appendCell("14-Jan-2015");
        ShortColumn c2 = this.column1.dayOfMonth();
        Assert.assertEquals((long)23L, (long)c2.get(0));
        Assert.assertEquals((long)24L, (long)c2.get(1));
        Assert.assertEquals((long)12L, (long)c2.get(2));
        Assert.assertEquals((long)14L, (long)c2.get(3));
    }

    @Test
    public void testMonth() throws Exception {
        this.column1.appendCell("2013-10-23");
        this.column1.appendCell("12/24/1924");
        this.column1.appendCell("12-May-2015");
        this.column1.appendCell("14-Jan-2015");
        ShortColumn c2 = this.column1.monthValue();
        Assert.assertEquals((long)10L, (long)c2.get(0));
        Assert.assertEquals((long)12L, (long)c2.get(1));
        Assert.assertEquals((long)5L, (long)c2.get(2));
        Assert.assertEquals((long)1L, (long)c2.get(3));
    }

    @Test
    public void testYear() throws Exception {
        this.column1.appendCell("2013-10-23");
        this.column1.appendCell("12/24/1924");
        this.column1.appendCell("12-May-2015");
        ShortColumn c2 = this.column1.year();
        Assert.assertEquals((long)2013L, (long)c2.get(0));
        Assert.assertEquals((long)1924L, (long)c2.get(1));
        Assert.assertEquals((long)2015L, (long)c2.get(2));
    }

    @Test
    public void testSummary() throws Exception {
        this.column1.appendCell("2013-10-23");
        this.column1.appendCell("12/24/1924");
        this.column1.appendCell("12-May-2015");
        this.column1.appendCell("14-Jan-2015");
        Table summary = this.column1.summary();
        Assert.assertEquals((long)4L, (long)summary.rowCount());
        Assert.assertEquals((long)2L, (long)summary.columnCount());
        Assert.assertEquals((Object)"Measure", (Object)summary.column(0).name());
        Assert.assertEquals((Object)"Value", (Object)summary.column(1).name());
    }
}

