/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.TestDataUtil;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.util.Selection;

public class CategoryColumnTest {
    private CategoryColumn column = new CategoryColumn("testing");

    @Before
    public void setUp() throws Exception {
        this.column.add("Value 1");
        this.column.add("Value 2");
        this.column.add("Value 3");
        this.column.add("Value 4");
    }

    @Test
    public void testDefaultReturnValue() {
        Assert.assertEquals((long)-1L, (long)this.column.dictionaryMap().get("test"));
    }

    @Test
    public void testType() {
        Assert.assertEquals((Object)ColumnType.CATEGORY, (Object)this.column.type());
    }

    @Test
    public void testGetString() {
        Assert.assertEquals((Object)"Value 2", (Object)this.column.getString(1));
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)4L, (long)this.column.size());
    }

    @Test
    public void testGetDummies() {
        List dummies = this.column.getDummies();
        Assert.assertEquals((long)4L, (long)dummies.size());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"Category column: testing", (Object)this.column.toString());
    }

    @Test
    public void testMax() {
        CategoryColumn categoryColumn = new CategoryColumn("US States");
        categoryColumn.addAll(TestDataUtil.usStates());
        Assert.assertTrue((boolean)"Wyoming".equals(categoryColumn.top(5).get(0)));
    }

    @Test
    public void testMin() {
        CategoryColumn categoryColumn = new CategoryColumn("US States");
        categoryColumn.addAll(TestDataUtil.usStates());
        Assert.assertTrue((boolean)"Alabama".equals(categoryColumn.bottom(5).get(0)));
    }

    @Test
    public void testStartsWith() {
        CategoryColumn categoryColumn = new CategoryColumn("US States");
        categoryColumn.addAll(TestDataUtil.usStates());
        Selection selection = categoryColumn.startsWith("A");
        Assert.assertEquals((Object)"Alabama", (Object)categoryColumn.get(selection.get(0)));
        Assert.assertEquals((Object)"Alaska", (Object)categoryColumn.get(selection.get(1)));
        Assert.assertEquals((Object)"Arizona", (Object)categoryColumn.get(selection.get(2)));
        Assert.assertEquals((Object)"Arkansas", (Object)categoryColumn.get(selection.get(3)));
        selection = categoryColumn.startsWith("T");
        Assert.assertEquals((Object)"Tennessee", (Object)categoryColumn.get(selection.get(0)));
        Assert.assertEquals((Object)"Texas", (Object)categoryColumn.get(selection.get(1)));
    }

    @Test
    public void testIsIn() {
        CategoryColumn categoryColumn = new CategoryColumn("US States");
        categoryColumn.addAll(TestDataUtil.usStates());
        Selection selection = categoryColumn.isIn(new String[]{"Alabama", "Texas"});
        Assert.assertEquals((Object)"Alabama", (Object)categoryColumn.get(selection.get(0)));
        Assert.assertEquals((Object)"Texas", (Object)categoryColumn.get(selection.get(1)));
        Assert.assertEquals((long)2L, (long)selection.size());
    }

    @Test
    public void testToList() {
        CategoryColumn categoryColumn = new CategoryColumn("US States");
        categoryColumn.addAll(TestDataUtil.usStates());
        List states = categoryColumn.toList();
        Assert.assertEquals((long)51L, (long)states.size());
    }
}

