/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.Table;

public class BooleanColumnTest {
    private final BooleanColumn column = new BooleanColumn("Test");

    @Before
    public void setup() {
        this.column.append(false);
        this.column.append(false);
        this.column.append(false);
        this.column.append(false);
        this.column.append(true);
        this.column.append(true);
        this.column.append(false);
    }

    @Test
    public void testGetElements() throws Exception {
        Assert.assertEquals((long)7L, (long)this.column.size());
    }

    @Test
    public void testCounts() throws Exception {
        Assert.assertEquals((long)7L, (long)this.column.size());
        Assert.assertEquals((long)7L, (long)(this.column.countTrue() + this.column.countFalse()));
        Assert.assertEquals((long)2L, (long)this.column.countTrue());
    }

    @Test
    public void testAddCell() throws Exception {
        this.column.append(true);
        Assert.assertEquals((long)8L, (long)this.column.size());
        this.column.appendCell("true");
        Assert.assertTrue((boolean)this.lastEntry());
        this.column.appendCell("false");
        Assert.assertFalse((boolean)this.lastEntry());
        this.column.appendCell("TRUE");
        Assert.assertTrue((boolean)this.lastEntry());
        this.column.appendCell("FALSE");
        Assert.assertFalse((boolean)this.lastEntry());
        this.column.appendCell("T");
        Assert.assertTrue((boolean)this.lastEntry());
        this.column.appendCell("F");
        Assert.assertFalse((boolean)this.lastEntry());
        this.column.appendCell("Y");
        Assert.assertTrue((boolean)this.lastEntry());
        this.column.appendCell("N");
        Assert.assertFalse((boolean)this.lastEntry());
        this.column.appendCell("");
        Assert.assertFalse((boolean)this.lastEntry());
    }

    @Test
    public void testGetType() throws Exception {
        Assert.assertEquals((Object)"Boolean".toUpperCase(), (Object)this.column.type().name());
    }

    @Test
    public void testSummary() throws Exception {
        Table summary = this.column.summary();
        Assert.assertEquals((long)2L, (long)summary.columnCount());
        Assert.assertEquals((long)2L, (long)summary.rowCount());
        Assert.assertEquals((Object)"false", (Object)summary.get(0, 0));
        Assert.assertEquals((Object)"5", (Object)summary.get(0, 1));
        Assert.assertEquals((Object)"true", (Object)summary.get(1, 0));
        Assert.assertEquals((Object)"2", (Object)summary.get(1, 1));
    }

    @Test
    public void testCountUnique() throws Exception {
        int result = this.column.countUnique();
        Assert.assertEquals((long)2L, (long)result);
    }

    @Test
    public void testToDoubleArray() throws Exception {
        double[] result = this.column.toDoubleArray();
        Assert.assertEquals((double)0.0, (double)result[0], (double)0.01);
        Assert.assertEquals((double)0.0, (double)result[1], (double)0.01);
        Assert.assertEquals((double)0.0, (double)result[2], (double)0.01);
        Assert.assertEquals((double)0.0, (double)result[3], (double)0.01);
        Assert.assertEquals((double)1.0, (double)result[4], (double)0.01);
        Assert.assertEquals((double)1.0, (double)result[5], (double)0.01);
        Assert.assertEquals((double)0.0, (double)result[6], (double)0.01);
    }

    @Test
    public void testBitmapConstructor() throws Exception {
        BooleanColumn bc = new BooleanColumn("Is false", this.column.isFalse(), this.column.size());
        Table summary = bc.summary();
        Assert.assertEquals((long)2L, (long)summary.columnCount());
        Assert.assertEquals((long)2L, (long)summary.rowCount());
        Assert.assertEquals((Object)"false", (Object)summary.get(0, 0));
        Assert.assertEquals((Object)"2", (Object)summary.get(0, 1));
        Assert.assertEquals((Object)"true", (Object)summary.get(1, 0));
        Assert.assertEquals((Object)"5", (Object)summary.get(1, 1));
    }

    @Test
    public void testConversionToInt() {
        int[] array = this.column.toIntArray();
        Assert.assertTrue((array[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((array[1] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((array[2] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((array[3] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((array[4] == 1 ? 1 : 0) != 0);
        Assert.assertTrue((array[5] == 1 ? 1 : 0) != 0);
        Assert.assertTrue((array[6] == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSelectionMethods() {
        Assert.assertEquals((long)5L, (long)this.column.isFalse().size());
        Assert.assertEquals((long)2L, (long)this.column.isTrue().size());
        Assert.assertEquals((long)7L, (long)this.column.isNotMissing().size());
        Assert.assertEquals((long)0L, (long)this.column.isMissing().size());
    }

    private boolean lastEntry() {
        return this.column.get(this.column.size() - 1);
    }
}

