/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.csv.CsvReadOptions;

public enum TestData {
    SIMPLE_DATA_WITH_CANONICAL_DATE_FORMAT(new String[]{"Name", "IQ", "City", "DOB"}, new ColumnType[]{ColumnType.CATEGORY, ColumnType.INTEGER, ColumnType.CATEGORY, ColumnType.LOCAL_DATE}, "../data/simple-data-with-canonical-date-format.csv"),
    SIMPLE_UNSORTED_DATA(new String[]{"Name", "IQ", "City", "DOB"}, new ColumnType[]{ColumnType.CATEGORY, ColumnType.INTEGER, ColumnType.CATEGORY, ColumnType.LOCAL_DATE}, "../data/unsorted-simple-data.csv"),
    SIMPLE_SORTED_DATA_BY_INTEGER_ASCENDING(new String[]{"Name", "IQ", "City", "DOB"}, new ColumnType[]{ColumnType.CATEGORY, ColumnType.INTEGER, ColumnType.CATEGORY, ColumnType.LOCAL_DATE}, "../data/simple-data-sort_by_int_ascending.csv"),
    SIMPLE_SORTED_DATA_BY_INTEGER_DESCENDING(new String[]{"Name", "IQ", "City", "DOB"}, new ColumnType[]{ColumnType.CATEGORY, ColumnType.INTEGER, ColumnType.CATEGORY, ColumnType.LOCAL_DATE}, "../data/simple-data-sort_by_int_descending.csv"),
    SIMPLE_SORTED_DATA_BY_INT_ASCENDING_AND_THEN_DATE_DESCENDING(new String[]{"Name", "IQ", "City", "DOB"}, new ColumnType[]{ColumnType.CATEGORY, ColumnType.INTEGER, ColumnType.CATEGORY, ColumnType.LOCAL_DATE}, "../data/simple-data-sort_by_int_ascending.csv"),
    SIMPLE_SORTED_DATA_BY_INTEGER_AND_DATE_ASCENDING(new String[]{"Name", "IQ", "City", "DOB"}, new ColumnType[]{ColumnType.CATEGORY, ColumnType.INTEGER, ColumnType.CATEGORY, ColumnType.LOCAL_DATE}, "../data/simple-data-sort_by_int_and_date_ascending.csv"),
    SIMPLE_SORTED_DATA_BY_INTEGER_AND_DATE_DESCENDING(new String[]{"Name", "IQ", "City", "DOB"}, new ColumnType[]{ColumnType.CATEGORY, ColumnType.INTEGER, ColumnType.CATEGORY, ColumnType.LOCAL_DATE}, "../data/simple-data-sort_by_int_and_date_descending.csv"),
    BUSH_APPROVAL(new String[]{"date", "approval", "who"}, new ColumnType[]{ColumnType.LOCAL_DATE, ColumnType.INTEGER, ColumnType.CATEGORY}, "../data/BushApproval.csv"),
    TORNADOES(new String[]{"Number", "Year", "Month", "Day", "Date", "Time", "Zone", "State", "State FIPS", "State No", "Scale", "Injuries", "Fatalities", "Loss", "Crop Loss", "Start Lat", "Start Lon", "End Lat", "End Lon", "Length", "Width", "NS", "SN", "SG", "FIPS 1", "FIPS 2", "FIPS 3", "FIPS 4"}, new ColumnType[]{ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.LOCAL_DATE, ColumnType.LOCAL_TIME, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.CATEGORY}, "../data/1950-2014_torn.csv");

    private Table table;
    private ColumnType[] columnTypes;
    private Path source;
    private String[] columnNames;

    private TestData(String[] columnNames, ColumnType[] columnTypes, String csvSource) {
        this.columnNames = columnNames;
        try {
            this.table = Table.read().csv(CsvReadOptions.builder((String)csvSource).columnTypes(columnTypes));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to read from CSV file");
        }
        this.columnTypes = columnTypes;
        this.source = Paths.get(csvSource, new String[0]);
    }

    public Table getTable() {
        return this.table;
    }

    public ColumnType[] getColumnTypes() {
        return this.columnTypes;
    }

    public Path getSource() {
        return this.source;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }
}

