/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class TableTest {
    private Table table;
    private FloatColumn floatColumn = new FloatColumn("f1");
    private DoubleColumn doubleColumn = new DoubleColumn("d1");

    @Before
    public void setUp() throws Exception {
        this.table = Table.create((String)"t");
        this.table.addColumn(new Column[]{this.floatColumn});
    }

    @Test
    public void testColumn() throws Exception {
        Column column1 = this.table.column(0);
        Assert.assertNotNull((Object)column1);
    }

    @Test
    public void testFullCopy() throws Exception {
        this.doubleColumn.append(2.23424);
        Table t = Table.create((String)"test");
        t.addColumn(new Column[]{this.doubleColumn});
        Table c = t.fullCopy();
        DoubleColumn doubles = c.doubleColumn(0);
        Assert.assertNotNull((Object)doubles);
        Assert.assertEquals((long)1L, (long)doubles.size());
    }

    @Test
    public void testColumnCount() throws Exception {
        Assert.assertEquals((long)0L, (long)Table.create((String)"t").columnCount());
        Assert.assertEquals((long)1L, (long)this.table.columnCount());
    }

    @Test
    public void testSampleSplit() throws Exception {
        Table t = Table.read().csv("../data/BushApproval.csv");
        Table[] results = t.sampleSplit(0.75);
        Assert.assertEquals((long)t.rowCount(), (long)(results[0].rowCount() + results[1].rowCount()));
    }

    @Test
    public void testRowCount() throws Exception {
        Assert.assertEquals((long)0L, (long)this.table.rowCount());
        FloatColumn floatColumn = this.floatColumn;
        floatColumn.append(2.0f);
        Assert.assertEquals((long)1L, (long)this.table.rowCount());
        floatColumn.append(2.2342f);
        Assert.assertEquals((long)2L, (long)this.table.rowCount());
    }
}

