/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.QueryHelper;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.packeddata.PackedLocalDate;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.io.csv.CsvReadOptions;

public class TableFilteringTest {
    private final ColumnType[] types = new ColumnType[]{ColumnType.LOCAL_DATE, ColumnType.INTEGER, ColumnType.CATEGORY};
    private Table table;

    @Before
    public void setUp() throws Exception {
        this.table = Table.read().csv(CsvReadOptions.builder((String)"../data/BushApproval.csv").columnTypes(this.types));
    }

    @Test
    public void testFilter1() {
        Table result = this.table.selectWhere(QueryHelper.column((String)"approval").isLessThan(70));
        IntColumn a = result.intColumn("approval");
        IntIterator intIterator = a.iterator();
        while (intIterator.hasNext()) {
            int v = (Integer)intIterator.next();
            Assert.assertTrue((v < 70 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFilter2() {
        Table result = this.table.selectWhere(QueryHelper.column((String)"date").isInApril());
        DateColumn d = result.dateColumn("date");
        for (LocalDate v : d) {
            Assert.assertTrue((boolean)PackedLocalDate.isInApril((int)PackedLocalDate.pack((LocalDate)v)));
        }
    }

    @Test
    public void testFilter3() {
        Table result = this.table.selectWhere(QueryHelper.both((Filter)QueryHelper.column((String)"date").isInApril(), (Filter)QueryHelper.column((String)"approval").isGreaterThan(70)));
        DateColumn dates = result.dateColumn("date");
        IntColumn approval = result.intColumn("approval");
        IntIterator intIterator = result.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            Assert.assertTrue((boolean)PackedLocalDate.isInApril((int)dates.getInt(row)));
            Assert.assertTrue((approval.get(row) > 70 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFilter4() {
        Table result = this.table.select(new String[]{"who", "approval"}).where(QueryHelper.and((Filter[])new Filter[]{QueryHelper.column((String)"date").isInApril(), QueryHelper.column((String)"approval").isGreaterThan(70)}));
        Assert.assertEquals((long)2L, (long)result.columnCount());
        Assert.assertTrue((boolean)result.columnNames().contains("who"));
        Assert.assertTrue((boolean)result.columnNames().contains("approval"));
    }
}

