/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw;

import org.junit.Assert;
import org.junit.Before;
import org.junit.ComparisonFailure;
import org.junit.Test;
import tech.tablesaw.TestData;
import tech.tablesaw.api.Table;

public class SortTest {
    private static final int IQ_INDEX = 1;
    private static final int DOB_INDEX = 3;
    private static final String[] columnNames = TestData.SIMPLE_UNSORTED_DATA.getColumnNames();
    private Table unsortedTable;

    @Before
    public void setup() {
        this.unsortedTable = TestData.SIMPLE_UNSORTED_DATA.getTable();
    }

    @Test
    public void sortAscending() {
        Table sortedTable = this.unsortedTable.sortAscendingOn(new String[]{"IQ", "DOB"});
        Table expectedResults = TestData.SIMPLE_SORTED_DATA_BY_INTEGER_AND_DATE_ASCENDING.getTable();
        this.compareTables(sortedTable, expectedResults);
    }

    @Test
    public void sortDescending() {
        this.unsortedTable = TestData.SIMPLE_UNSORTED_DATA.getTable();
        Table sortedTable = this.unsortedTable.sortDescendingOn(new String[]{"IQ", "DOB"});
        Table expectedResults = TestData.SIMPLE_SORTED_DATA_BY_INTEGER_AND_DATE_DESCENDING.getTable();
        this.compareTables(sortedTable, expectedResults);
    }

    @Test(expected=ComparisonFailure.class)
    public void sortDescendingNegative() {
        Table sortedTable = this.unsortedTable.sortDescendingOn(new String[]{"IQ", "DOB"});
        Table expectedResults = TestData.SIMPLE_SORTED_DATA_BY_INTEGER_AND_DATE_ASCENDING.getTable();
        this.compareTables(sortedTable, expectedResults);
    }

    @Test
    public void testMultipleSortOrdersVerifyMinus() {
        Table sortedTable = this.unsortedTable.sortOn(new String[]{"-" + columnNames[1], "-" + columnNames[3]});
        Table expectedResults = TestData.SIMPLE_SORTED_DATA_BY_INTEGER_AND_DATE_DESCENDING.getTable();
        this.compareTables(expectedResults, sortedTable);
    }

    @Test
    public void testAscendingAndDescending() {
        Table sortedTable = this.unsortedTable.sortOn(new String[]{"+" + columnNames[1], "-" + columnNames[3]});
        Table expectedResults = TestData.SIMPLE_SORTED_DATA_BY_INT_ASCENDING_AND_THEN_DATE_DESCENDING.getTable();
        this.compareTables(expectedResults, sortedTable);
    }

    @Test
    public void testMultipleSortOrdersVerifyPlus() {
        Table sortedTable = this.unsortedTable.sortOn(new String[]{"+" + columnNames[1], "+" + columnNames[3]});
        Table expectedResults = TestData.SIMPLE_SORTED_DATA_BY_INTEGER_AND_DATE_ASCENDING.getTable();
        this.compareTables(expectedResults, sortedTable);
        sortedTable = this.unsortedTable.sortOn(new String[]{columnNames[1], columnNames[3]});
        expectedResults = TestData.SIMPLE_SORTED_DATA_BY_INTEGER_AND_DATE_ASCENDING.getTable();
        this.compareTables(expectedResults, sortedTable);
    }

    @Test
    public void testAscendingWithPlusSign() {
        Table sortedTable = this.unsortedTable.sortOn(new String[]{"+" + columnNames[1]});
        Table expectedResults = TestData.SIMPLE_SORTED_DATA_BY_INTEGER_ASCENDING.getTable();
        this.compareTables(expectedResults, sortedTable);
    }

    @Test(expected=ComparisonFailure.class)
    public void testAscendingWithPlusSignNegative() {
        Table sortedTable = this.unsortedTable.sortOn(new String[]{"+" + columnNames[1], "-" + columnNames[3]});
        Table expectedResults = TestData.SIMPLE_DATA_WITH_CANONICAL_DATE_FORMAT.getTable();
        this.compareTables(expectedResults, sortedTable);
    }

    private void compareTables(Table sortedTable, Table compareWith) {
        Assert.assertEquals((String)"both tables have the same number of rows", (long)sortedTable.rowCount(), (long)compareWith.rowCount());
        int maxRows = sortedTable.rowCount();
        int numberOfColumns = sortedTable.columnCount();
        for (int rowIndex = 0; rowIndex < maxRows; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < numberOfColumns; ++columnIndex) {
                Assert.assertEquals((String)("cells[" + rowIndex + ", " + columnIndex + "]  match"), (Object)sortedTable.get(rowIndex, columnIndex), (Object)compareWith.get(rowIndex, columnIndex));
            }
        }
    }
}

