/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.reducing.functions;

import tech.tablesaw.api.Table;
import tech.tablesaw.reducing.NumericReduceFunction;
import tech.tablesaw.reducing.NumericSummaryTable;
import tech.tablesaw.table.ViewGroup;

public abstract class SummaryFunction {
    private final Table original;
    private final String summarizedColumnName;

    public SummaryFunction(Table original, String summarizedColumnName) {
        this.original = original;
        this.summarizedColumnName = summarizedColumnName;
    }

    public String summarizedColumnName() {
        return this.summarizedColumnName;
    }

    Table original() {
        return this.original;
    }

    public NumericSummaryTable by(String ... columnNames) {
        ViewGroup group = ViewGroup.create(this.original(), columnNames);
        return group.reduce(this.summarizedColumnName(), this.function());
    }

    public double get() {
        return this.original.reduce(this.summarizedColumnName, this.function());
    }

    public abstract NumericReduceFunction function();
}

