/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.reducing;

import com.google.common.collect.TreeBasedTable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.time.LocalDate;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public final class CrossTab {
    public static Table xCount(Table table, Column column1, Column column2) {
        if (column1.type() == ColumnType.FLOAT || column2.type() == ColumnType.FLOAT) {
            throw new UnsupportedOperationException("X-tabs on FLOAT columns are not supported");
        }
        return CrossTab.xTabCount(table, column1, column2);
    }

    public static Table xTabCount(Table table, Column column1, Column column2) {
        Table t = Table.create("Crosstab Counts: " + column1.name() + " x " + column2.name());
        t.addColumn(new CategoryColumn(""));
        Table temp = table.sortOn(column1.name(), column2.name());
        int colIndex1 = table.columnIndex(column1.name());
        int colIndex2 = table.columnIndex(column2.name());
        TreeBasedTable gTable = TreeBasedTable.create();
        IntIterator intIterator = temp.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            String a = temp.column(colIndex1).getString(row);
            String b = temp.column(colIndex2).getString(row);
            Integer cellValue = (Integer)gTable.get((Object)a, (Object)b);
            Integer value = 0;
            value = cellValue != null ? Integer.valueOf(cellValue + 1) : Integer.valueOf(1);
            gTable.put((Object)a, (Object)b, (Object)value);
        }
        for (String colName : gTable.columnKeySet()) {
            t.addColumn(new IntColumn(colName));
        }
        t.addColumn(new IntColumn("total"));
        int[] columnTotals = new int[t.columnCount()];
        for (String rowKey : gTable.rowKeySet()) {
            t.column(0).appendCell(rowKey);
            int rowSum = 0;
            for (String colKey : gTable.columnKeySet()) {
                Integer cellValue = (Integer)gTable.get((Object)rowKey, (Object)colKey);
                if (cellValue != null) {
                    int colIdx = t.columnIndex(colKey);
                    t.intColumn(colIdx).append(cellValue);
                    rowSum += cellValue.intValue();
                    columnTotals[colIdx] = columnTotals[colIdx] + cellValue;
                    continue;
                }
                t.intColumn(colKey).append(0);
            }
            t.intColumn(t.columnCount() - 1).append(rowSum);
        }
        t.column(0).appendCell("Total");
        int grandTotal = 0;
        for (int i = 1; i < t.columnCount() - 1; ++i) {
            t.intColumn(i).append(columnTotals[i]);
            grandTotal += columnTotals[i];
        }
        t.intColumn(t.columnCount() - 1).append(grandTotal);
        return t;
    }

    public static Table xTabCount(Table table, DateColumn column1, Column column2) {
        Table t = Table.create("CrossTab Counts");
        t.addColumn(new CategoryColumn("value"));
        Table temp = table.sortOn(column1.name(), column2.name());
        int colIndex2 = table.columnIndex(column2.name());
        TreeBasedTable gTable = TreeBasedTable.create();
        IntIterator intIterator = temp.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            LocalDate a = temp.dateColumn(column1.name()).get(row);
            String b = temp.column(colIndex2).getString(row);
            Integer cellValue = (Integer)gTable.get((Object)a, (Object)b);
            Integer value = 0;
            if (cellValue != null) {
                value = cellValue + 1;
            }
            gTable.put((Object)a, (Object)b, (Object)value);
        }
        for (String colName : gTable.columnKeySet()) {
            t.addColumn(new FloatColumn(colName));
        }
        t.addColumn(new FloatColumn("total"));
        int[] columnTotals = new int[t.columnCount()];
        for (LocalDate rowKey : gTable.rowKeySet()) {
            t.dateColumn(0).append(rowKey);
            int rowSum = 0;
            for (String colKey : gTable.columnKeySet()) {
                Integer cellValue = (Integer)gTable.get((Object)rowKey, (Object)colKey);
                if (cellValue != null) {
                    int colIdx = t.columnIndex(colKey);
                    t.intColumn(colIdx).append(cellValue);
                    rowSum += cellValue.intValue();
                    columnTotals[colIdx] = columnTotals[colIdx] + cellValue;
                    continue;
                }
                t.intColumn(colKey).append(0);
            }
            t.intColumn(t.columnCount() - 1).append(rowSum);
        }
        t.column(0).appendCell("Total");
        int grandTotal = 0;
        for (int i = 1; i < t.columnCount() - 1; ++i) {
            t.intColumn(i).append(columnTotals[i]);
            grandTotal += columnTotals[i];
        }
        t.intColumn(t.columnCount() - 1).append(grandTotal);
        return t;
    }

    public static Table rowPercents(Table xTabCounts) {
        int i;
        Table pctTable = Table.create("Crosstab Row Proportions: ");
        CategoryColumn labels = new CategoryColumn("");
        pctTable.addColumn(labels);
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            labels.add(xTabCounts.column(0).getString(i));
        }
        for (i = 1; i < xTabCounts.columnCount(); ++i) {
            Column column = xTabCounts.column(i);
            pctTable.addColumn(new FloatColumn(column.name()));
        }
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            float rowTotal = xTabCounts.intColumn(xTabCounts.columnCount() - 1).get(i);
            for (int c = 1; c < xTabCounts.columnCount(); ++c) {
                if (rowTotal == 0.0f) {
                    pctTable.floatColumn(c).append(Float.NaN);
                    continue;
                }
                pctTable.floatColumn(c).append((float)xTabCounts.intColumn(c).get(i) / rowTotal);
            }
        }
        return pctTable;
    }

    public static Table tablePercents(Table xTabCounts) {
        int i;
        Table pctTable = Table.create("Crosstab Table Proportions: ");
        CategoryColumn labels = new CategoryColumn("");
        pctTable.addColumn(labels);
        int grandTotal = xTabCounts.intColumn(xTabCounts.columnCount() - 1).get(xTabCounts.rowCount() - 1);
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            labels.add(xTabCounts.column(0).getString(i));
        }
        for (i = 1; i < xTabCounts.columnCount(); ++i) {
            Column column = xTabCounts.column(i);
            pctTable.addColumn(new FloatColumn(column.name()));
        }
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            for (int c = 1; c < xTabCounts.columnCount(); ++c) {
                if (grandTotal == 0) {
                    pctTable.floatColumn(c).append(Float.NaN);
                    continue;
                }
                pctTable.floatColumn(c).append((float)xTabCounts.intColumn(c).get(i) / (float)grandTotal);
            }
        }
        return pctTable;
    }

    public static Table columnPercents(Table xTabCounts) {
        int i;
        int i2;
        Table pctTable = Table.create("Crosstab Column Proportions: ");
        CategoryColumn labels = new CategoryColumn("");
        pctTable.addColumn(labels);
        for (i2 = 0; i2 < xTabCounts.rowCount(); ++i2) {
            labels.add(xTabCounts.column(0).getString(i2));
        }
        for (i2 = 1; i2 < xTabCounts.columnCount(); ++i2) {
            Column column = xTabCounts.column(i2);
            pctTable.addColumn(new FloatColumn(column.name()));
        }
        int[] columnTotals = new int[xTabCounts.columnCount() - 1];
        int totalRow = xTabCounts.rowCount() - 1;
        for (i = 1; i < xTabCounts.columnCount(); ++i) {
            columnTotals[i - 1] = xTabCounts.intColumn(i).get(totalRow);
        }
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            for (int c = 1; c < xTabCounts.columnCount(); ++c) {
                if (columnTotals[c - 1] == 0) {
                    pctTable.floatColumn(c).append(Float.NaN);
                    continue;
                }
                pctTable.floatColumn(c).append((float)xTabCounts.intColumn(c).get(i) / (float)columnTotals[c - 1]);
            }
        }
        return pctTable;
    }
}

