/*
 * Decompiled with CFR 0.152.
 */
package tachiyomi.source;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tachiyomi.core.http.RequestsKt;
import tachiyomi.source.CatalogSource;
import tachiyomi.source.Dependencies;
import tachiyomi.source.model.ImageUrl;
import tachiyomi.source.model.Listing;
import tachiyomi.source.model.PageComplete;
import tachiyomi.source.model.PageUrl;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\u0019\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020&H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020\u0006H\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"Ltachiyomi/source/HttpSource;", "Ltachiyomi/source/CatalogSource;", "dependencies", "Ltachiyomi/source/Dependencies;", "(Ltachiyomi/source/Dependencies;)V", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "headers", "Lokhttp3/Headers;", "getHeaders", "()Lokhttp3/Headers;", "headers$delegate", "Lkotlin/Lazy;", "id", "", "getId", "()J", "id$delegate", "versionId", "", "getVersionId", "()I", "getImageRequest", "Lokhttp3/Request;", "page", "Ltachiyomi/source/model/ImageUrl;", "(Ltachiyomi/source/model/ImageUrl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getListings", "", "Ltachiyomi/source/model/Listing;", "getPage", "Ltachiyomi/source/model/PageComplete;", "Ltachiyomi/source/model/PageUrl;", "(Ltachiyomi/source/model/PageUrl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "headersBuilder", "Lokhttp3/Headers$Builder;", "toString", "source-api"})
public abstract class HttpSource
implements CatalogSource {
    private final int versionId;
    @NotNull
    private final Lazy id$delegate;
    @NotNull
    private final Lazy headers$delegate;
    private final Dependencies dependencies;

    @NotNull
    public abstract String getBaseUrl();

    public int getVersionId() {
        return this.versionId;
    }

    @Override
    public long getId() {
        Lazy lazy = this.id$delegate;
        HttpSource httpSource = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).longValue();
    }

    @NotNull
    public final Headers getHeaders() {
        Lazy lazy = this.headers$delegate;
        HttpSource httpSource = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Headers)lazy.getValue();
    }

    @NotNull
    public OkHttpClient getClient() {
        return this.dependencies.getHttp().getDefaultClient();
    }

    @NotNull
    protected Headers.Builder headersBuilder() {
        Headers.Builder builder = new Headers.Builder();
        boolean bl = false;
        boolean bl2 = false;
        Headers.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.add("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64)");
        return builder;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getName()).append(" (");
        String string = this.getLang();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        return stringBuilder.append(string3).append(')').toString();
    }

    @Nullable
    public Object getPage(@NotNull PageUrl pageUrl, @NotNull Continuation<? super PageComplete> $completion) {
        return HttpSource.getPage$suspendImpl(this, pageUrl, $completion);
    }

    static /* synthetic */ Object getPage$suspendImpl(HttpSource this_, PageUrl page, Continuation $completion) {
        throw (Throwable)new Exception("Incomplete source implementation. Please override getPage when using PageUrl");
    }

    @Nullable
    public Object getImageRequest(@NotNull ImageUrl imageUrl, @NotNull Continuation<? super Request> $completion) {
        return HttpSource.getImageRequest$suspendImpl(this, imageUrl, $completion);
    }

    static /* synthetic */ Object getImageRequest$suspendImpl(HttpSource this_, ImageUrl page, Continuation $completion) {
        return RequestsKt.GET$default((String)page.getUrl(), (Headers)this_.getHeaders(), null, (int)4, null);
    }

    @Override
    @NotNull
    public List<Listing> getListings() {
        return CollectionsKt.emptyList();
    }

    public HttpSource(@NotNull Dependencies dependencies) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        this.dependencies = dependencies;
        this.versionId = 1;
        this.id$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ HttpSource this$0;

            /*
             * WARNING - void declaration
             */
            public final long invoke() {
                void $this$mapTo$iv$iv;
                StringBuilder stringBuilder = new StringBuilder();
                String string = this.this$0.getName();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String key = stringBuilder.append(string3).append('/').append(this.this$0.getLang()).append('/').append(this.this$0.getVersionId()).toString();
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                String string4 = key;
                Charset charset = Charsets.UTF_8;
                boolean bl2 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string5.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] bytes = messageDigest.digest(byArray);
                int n = 0;
                Iterable $this$map$iv = (Iterable)new IntRange(n, 7);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Long l = ((long)bytes[it] & 0xFFL) << 8 * (7 - it);
                    collection.add(l);
                }
                Iterable $this$reduce$iv = (List)destination$iv$iv;
                boolean $i$f$reduce = false;
                Iterator<T> iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p2;
                    long $i$f$mapTo2 = ((Number)iterator$iv.next()).longValue();
                    long p1 = ((Number)accumulator$iv).longValue();
                    boolean bl4 = false;
                    accumulator$iv = p1 | p2;
                }
                return ((Number)accumulator$iv).longValue() & Long.MAX_VALUE;
            }
            {
                this.this$0 = httpSource;
                super(0);
            }
        }));
        this.headers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Headers>(this){
            final /* synthetic */ HttpSource this$0;

            @NotNull
            public final Headers invoke() {
                return this.this$0.headersBuilder().build();
            }
            {
                this.this$0 = httpSource;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public Regex getRegex() {
        return CatalogSource.DefaultImpls.getRegex(this);
    }
}

