/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.internal.widgets.FormUtil;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.LayoutComposite;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;

public class FormToolkit {
    public static final String KEY_DRAW_BORDER = "FormWidgetFactory.drawBorder";
    public static final String TREE_BORDER = "treeBorder";
    public static final String TEXT_BORDER = "textBorder";
    private int borderStyle = 0;
    private FormColors colors;
    private KeyListener deleteListener;
    private BorderPainter borderPainter;
    private HyperlinkGroup hyperlinkGroup;
    VisibilityHandler visibilityHandler;
    KeyboardHandler keyboardHandler;

    public FormToolkit(Display display) {
        this(new FormColors(display));
    }

    public FormToolkit(FormColors colors) {
        this.colors = colors;
        this.initialize();
    }

    public Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style | 0x800000);
        if (text != null) {
            button.setText(text);
        }
        this.adapt((Control)button, true, true);
        return button;
    }

    public Composite createComposite(Composite parent) {
        return this.createComposite(parent, 0);
    }

    public Composite createComposite(Composite parent, int style) {
        LayoutComposite composite = new LayoutComposite(parent, style);
        this.adapt(composite);
        return composite;
    }

    public Composite createCompositeSeparator(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        composite.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (composite.isDisposed()) {
                    return;
                }
                Rectangle bounds = composite.getBounds();
                GC gc = e.gc;
                gc.setForeground(FormToolkit.this.colors.getColor("org.eclipse.ui.forms.SEPARATOR"));
                gc.setBackground(FormToolkit.this.colors.getBackground());
                gc.fillGradientRectangle(0, 0, bounds.width, bounds.height, false);
            }
        });
        if (parent instanceof Section) {
            ((Section)parent).setSeparatorControl((Control)composite);
        }
        return composite;
    }

    public Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 0);
    }

    public Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        this.adapt((Control)label, false, false);
        return label;
    }

    public Hyperlink createHyperlink(Composite parent, String text, int style) {
        Hyperlink hyperlink = new Hyperlink(parent, style);
        if (text != null) {
            hyperlink.setText(text);
        }
        hyperlink.addFocusListener((FocusListener)this.visibilityHandler);
        hyperlink.addKeyListener((KeyListener)this.keyboardHandler);
        this.hyperlinkGroup.add(hyperlink);
        return hyperlink;
    }

    public ImageHyperlink createImageHyperlink(Composite parent, int style) {
        ImageHyperlink hyperlink = new ImageHyperlink(parent, style);
        hyperlink.addFocusListener((FocusListener)this.visibilityHandler);
        hyperlink.addKeyListener((KeyListener)this.keyboardHandler);
        this.hyperlinkGroup.add(hyperlink);
        return hyperlink;
    }

    public FormText createFormText(Composite parent, boolean trackFocus) {
        FormText engine = new FormText(parent, 64);
        engine.marginWidth = 1;
        engine.marginHeight = 0;
        engine.setHyperlinkSettings(this.getHyperlinkGroup());
        this.adapt((Control)engine, trackFocus, true);
        engine.setMenu(parent.getMenu());
        return engine;
    }

    public void adapt(Control control, boolean trackFocus, boolean trackKeyboard) {
        control.setBackground(this.colors.getBackground());
        control.setForeground(this.colors.getForeground());
        if (trackFocus) {
            control.addFocusListener((FocusListener)this.visibilityHandler);
        }
        if (trackKeyboard) {
            control.addKeyListener((KeyListener)this.keyboardHandler);
        }
    }

    public void adapt(Composite composite) {
        composite.setBackground(this.colors.getBackground());
        composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ((Control)e.widget).setFocus();
            }
        });
        composite.setMenu(composite.getParent().getMenu());
    }

    public Section createSection(Composite parent, int sectionStyle) {
        Section section = new Section(parent, sectionStyle);
        section.setBackground(this.colors.getBackground());
        section.setForeground(this.colors.getForeground());
        section.setMenu(parent.getMenu());
        section.textLabel.addFocusListener((FocusListener)this.visibilityHandler);
        section.textLabel.addKeyListener((KeyListener)this.keyboardHandler);
        if (section.toggle != null) {
            section.toggle.addFocusListener((FocusListener)this.visibilityHandler);
            section.toggle.addKeyListener((KeyListener)this.keyboardHandler);
            section.toggle.setHoverDecorationColor(this.getHyperlinkGroup().getActiveForeground());
            section.toggle.setDecorationColor(this.colors.getColor("org.eclipse.ui.forms.SEPARATOR"));
        }
        section.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return section;
    }

    public ExpandableComposite createExpandableComposite(Composite parent, int expansionStyle) {
        ExpandableComposite ec = new ExpandableComposite(parent, 0, expansionStyle);
        ec.setMenu(parent.getMenu());
        ec.setBackground(this.colors.getBackground());
        ec.setForeground(this.colors.getForeground());
        if (ec.toggle != null) {
            ec.toggle.addFocusListener((FocusListener)this.visibilityHandler);
            ec.toggle.addKeyListener((KeyListener)this.keyboardHandler);
        }
        ec.textLabel.addFocusListener((FocusListener)this.visibilityHandler);
        ec.textLabel.addKeyListener((KeyListener)this.keyboardHandler);
        ec.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return ec;
    }

    public Label createSeparator(Composite parent, int style) {
        Label label = new Label(parent, 2 | style);
        label.setBackground(this.colors.getBackground());
        label.setForeground(this.colors.getBorderColor());
        return label;
    }

    public Table createTable(Composite parent, int style) {
        Table table = new Table(parent, style | this.borderStyle);
        this.adapt((Control)table, false, false);
        this.hookDeleteListener((Control)table);
        return table;
    }

    public Text createText(Composite parent, String value) {
        return this.createText(parent, value, 4);
    }

    public Text createText(Composite parent, String value, int style) {
        Text text = new Text(parent, this.borderStyle | style);
        if (value != null) {
            text.setText(value);
        }
        this.adapt((Control)text, true, false);
        return text;
    }

    public Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, this.borderStyle | style);
        this.adapt((Control)tree, false, false);
        this.hookDeleteListener((Control)tree);
        return tree;
    }

    public ScrolledForm createScrolledForm(Composite parent) {
        ScrolledForm form = new ScrolledForm(parent);
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        form.setBackground(this.colors.getBackground());
        form.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        form.setFont(JFaceResources.getHeaderFont());
        return form;
    }

    public Form createForm(Composite parent) {
        Form formContent = new Form(parent, 0);
        formContent.setBackground(this.colors.getBackground());
        formContent.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        formContent.setFont(JFaceResources.getHeaderFont());
        return formContent;
    }

    public ScrolledPageBook createPageBook(Composite parent, int style) {
        ScrolledPageBook book = new ScrolledPageBook(parent, style);
        this.adapt((Control)book, true, true);
        book.setMenu(parent.getMenu());
        return book;
    }

    public void dispose() {
        if (!this.colors.isShared()) {
            this.colors.dispose();
            this.colors = null;
        }
    }

    public HyperlinkGroup getHyperlinkGroup() {
        return this.hyperlinkGroup;
    }

    public void hookDeleteListener(Control control) {
        if (this.deleteListener == null) {
            this.deleteListener = new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.character == '\u007f') {
                        event.getClass();
                    }
                }
            };
        }
        control.addKeyListener(this.deleteListener);
    }

    public void setBackground(Color bg) {
        this.hyperlinkGroup.setBackground(bg);
        this.colors.setBackground(bg);
    }

    public void refreshHyperlinkColors() {
        this.hyperlinkGroup.initializeDefaultForegrounds(this.colors.getDisplay());
    }

    public void paintBordersFor(Composite parent) {
        if (this.borderStyle == 2048) {
            return;
        }
        if (this.borderPainter == null) {
            this.borderPainter = new BorderPainter();
        }
        parent.addPaintListener((PaintListener)this.borderPainter);
    }

    public FormColors getColors() {
        return this.colors;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int style) {
        this.borderStyle = style;
    }

    private void initialize() {
        String osname = System.getProperty("os.name");
        if (osname.equals("Windows XP")) {
            this.borderStyle = 2048;
        }
        this.hyperlinkGroup = new HyperlinkGroup(this.colors.getDisplay());
        this.hyperlinkGroup.setBackground(this.colors.getBackground());
        this.visibilityHandler = new VisibilityHandler();
        this.keyboardHandler = new KeyboardHandler();
    }

    private class BorderPainter
    implements PaintListener {
        BorderPainter() {
        }

        public void paintControl(PaintEvent event) {
            Composite composite = (Composite)event.widget;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                block12: {
                    GC gc;
                    Rectangle b;
                    boolean textBorder;
                    boolean inactiveBorder;
                    Control c;
                    block13: {
                        c = children[i];
                        inactiveBorder = false;
                        textBorder = false;
                        if (!c.isVisible() || !c.getEnabled() && !(c instanceof CCombo) || c instanceof Hyperlink) break block12;
                        Object flag = c.getData(FormToolkit.KEY_DRAW_BORDER);
                        if (flag == null) break block13;
                        if (flag.equals(Boolean.FALSE)) break block12;
                        if (flag.equals(FormToolkit.TREE_BORDER)) {
                            inactiveBorder = true;
                        } else if (flag.equals(FormToolkit.TEXT_BORDER)) {
                            textBorder = true;
                        }
                    }
                    if (!inactiveBorder && (c instanceof Text || c instanceof CCombo || textBorder)) {
                        b = c.getBounds();
                        gc = event.gc;
                        gc.setForeground(c.getBackground());
                        gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                        gc.setForeground(FormToolkit.this.colors.getForeground());
                        if (c instanceof CCombo) {
                            gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                        } else {
                            gc.drawRectangle(b.x - 1, b.y - 2, b.width + 1, b.height + 3);
                        }
                    } else if (inactiveBorder || c instanceof Table || c instanceof Tree || c instanceof TableTree) {
                        b = c.getBounds();
                        gc = event.gc;
                        gc.setForeground(FormToolkit.this.colors.getBorderColor());
                        gc.drawRectangle(b.x - 1, b.y - 1, b.width + 2, b.height + 2);
                    }
                }
                ++i;
            }
        }
    }

    private static class VisibilityHandler
    extends FocusAdapter {
        VisibilityHandler() {
        }

        public void focusGained(FocusEvent e) {
            Widget w = e.widget;
            if (w instanceof Control) {
                FormUtil.ensureVisible((Control)w);
            }
        }
    }

    private static class KeyboardHandler
    extends KeyAdapter {
        KeyboardHandler() {
        }

        public void keyPressed(KeyEvent e) {
            Widget w = e.widget;
            if (w instanceof Control) {
                FormUtil.processKey(e.keyCode, (Control)w);
            }
        }
    }
}

