/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.FormWizard;

public class FormWizardDialog
extends WizardDialog {
    protected FormColors colors;

    public FormWizardDialog(Shell shell, FormWizard wizard, FormColors colors) {
        super(shell, (IWizard)wizard);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.colors = colors;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.setChildColors(c);
        c.setBackground(this.colors.getBackground());
        c.setForeground(this.colors.getForeground());
        return c;
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        bar.setBackground(this.colors.getBackground());
        bar.setForeground(this.colors.getForeground());
        parent.setBackground(this.colors.getBackground());
        parent.setForeground(this.colors.getForeground());
        return bar;
    }

    private void setChildColors(Composite parent) {
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            Layout l;
            Control child = children[i];
            child.setBackground(this.colors.getBackground());
            if (child instanceof ProgressMonitorPart) {
                this.setChildColors((Composite)((ProgressMonitorPart)child));
            }
            if (child instanceof Composite && (l = ((Composite)child).getLayout()) instanceof WizardDialog.PageContainerFillLayout) {
                WizardDialog.PageContainerFillLayout pl = (WizardDialog.PageContainerFillLayout)l;
                pl.marginWidth = 0;
                pl.marginHeight = 0;
            }
            ++i;
        }
    }
}

