/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.orm.jdo.DefaultJdoDialect;
import org.springframework.orm.jdo.JdoDialect;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdoTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private PersistenceManagerFactory persistenceManagerFactory;
    private DataSource dataSource;
    private boolean autodetectDataSource = true;
    private JdoDialect jdoDialect = new DefaultJdoDialect();

    public JdoTransactionManager() {
    }

    public JdoTransactionManager(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
        this.afterPropertiesSet();
    }

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setAutodetectDataSource(boolean autodetectDataSource) {
        this.autodetectDataSource = autodetectDataSource;
    }

    public void setJdoDialect(JdoDialect jdoDialect) {
        this.jdoDialect = jdoDialect;
    }

    public JdoDialect getJdoDialect() {
        if (this.jdoDialect == null) {
            this.jdoDialect = new DefaultJdoDialect(this.getPersistenceManagerFactory());
        }
        return this.jdoDialect;
    }

    public void afterPropertiesSet() {
        Object pmfcf;
        if (this.getPersistenceManagerFactory() == null) {
            throw new IllegalArgumentException("persistenceManagerFactory is required");
        }
        this.getJdoDialect();
        if (this.autodetectDataSource && this.getDataSource() == null && (pmfcf = this.getPersistenceManagerFactory().getConnectionFactory()) instanceof DataSource) {
            this.dataSource = (DataSource)pmfcf;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using DataSource [" + this.dataSource + "] of JDO PersistenceManagerFactory for JdoTransactionManager"));
            }
        }
    }

    protected Object doGetTransaction() {
        JdoTransactionObject txObject = new JdoTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        if (TransactionSynchronizationManager.hasResource(this.getPersistenceManagerFactory())) {
            PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.getResource(this.getPersistenceManagerFactory());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound persistence manager [" + pmHolder.getPersistenceManager() + "] for JDO transaction"));
            }
            txObject.setPersistenceManagerHolder(pmHolder, false);
            if (this.getDataSource() != null) {
                ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.getDataSource());
                txObject.setConnectionHolder(conHolder);
            }
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((JdoTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        PersistenceManager pm;
        JdoTransactionObject txObject;
        if (this.getDataSource() != null && TransactionSynchronizationManager.hasResource(this.getDataSource())) {
            throw new IllegalTransactionStateException("Pre-bound JDBC connection found - JdoTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single JdoTransactionManager for all transactions on a single DataSource, no matter whether JDO or JDBC access.");
        }
        if (definition.isReadOnly()) {
            this.logger.info((Object)"JdoTransactionManager does not support read-only transactions: ignoring 'readOnly' hint");
        }
        if ((txObject = (JdoTransactionObject)transaction).getPersistenceManagerHolder() == null) {
            pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), true, false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Opened new persistence manager [" + pm + "] for JDO transaction"));
            }
            txObject.setPersistenceManagerHolder(new PersistenceManagerHolder(pm), true);
        }
        txObject.getPersistenceManagerHolder().setSynchronizedWithTransaction(true);
        pm = txObject.getPersistenceManagerHolder().getPersistenceManager();
        try {
            Object transactionData = this.getJdoDialect().beginTransaction(pm.currentTransaction(), definition);
            txObject.setTransactionData(transactionData);
            if (definition.getTimeout() != -1) {
                txObject.getPersistenceManagerHolder().setTimeoutInSeconds(definition.getTimeout());
            }
            if (this.getDataSource() != null) {
                ConnectionHandle conHandle = this.getJdoDialect().getJdbcConnection(pm, definition.isReadOnly());
                if (conHandle != null) {
                    ConnectionHolder conHolder = new ConnectionHolder(conHandle);
                    if (definition.getTimeout() != -1) {
                        conHolder.setTimeoutInSeconds(definition.getTimeout());
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Exposing JDO transaction as JDBC transaction [" + conHolder.getConnection() + "]"));
                    }
                    TransactionSynchronizationManager.bindResource(this.getDataSource(), conHolder);
                    txObject.setConnectionHolder(conHolder);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Not exposing JDO transaction [" + pm + "] as JDBC transaction because JdoDialect [" + this.getJdoDialect() + "] does not support JDBC connection retrieval"));
                }
            }
            if (txObject.isNewPersistenceManagerHolder()) {
                TransactionSynchronizationManager.bindResource(this.getPersistenceManagerFactory(), txObject.getPersistenceManagerHolder());
            }
        }
        catch (TransactionException ex) {
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
            throw ex;
        }
        catch (Exception ex) {
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
            throw new CannotCreateTransactionException("Could not create JDO transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        JdoTransactionObject txObject = (JdoTransactionObject)transaction;
        txObject.setPersistenceManagerHolder(null, false);
        PersistenceManagerHolder persistenceManagerHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.unbindResource(this.getPersistenceManagerFactory());
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        return new SuspendedResourcesHolder(persistenceManagerHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.getPersistenceManagerFactory(), resourcesHolder.getPersistenceManagerHolder());
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource(this.getDataSource(), resourcesHolder.getConnectionHolder());
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        JdoTransactionObject txObject = (JdoTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing JDO transaction on persistence manager [" + txObject.getPersistenceManagerHolder().getPersistenceManager() + "]"));
        }
        try {
            txObject.getPersistenceManagerHolder().getPersistenceManager().currentTransaction().commit();
        }
        catch (JDOException ex) {
            throw this.convertJdoAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        JdoTransactionObject txObject = (JdoTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back JDO transaction on persistence manager [" + txObject.getPersistenceManagerHolder().getPersistenceManager() + "]"));
        }
        try {
            txObject.getPersistenceManagerHolder().getPersistenceManager().currentTransaction().rollback();
        }
        catch (JDOException ex) {
            throw new TransactionSystemException("Could not roll back JDO transaction", ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JdoTransactionObject txObject = (JdoTransactionObject)status.getTransaction();
        this.logger.debug((Object)"Setting JDO transaction rollback-only");
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        JdoTransactionObject txObject = (JdoTransactionObject)transaction;
        if (txObject.isNewPersistenceManagerHolder()) {
            TransactionSynchronizationManager.unbindResource(this.getPersistenceManagerFactory());
        }
        txObject.getPersistenceManagerHolder().clear();
        if (txObject.getConnectionHolder() != null) {
            TransactionSynchronizationManager.unbindResource(this.getDataSource());
            try {
                this.getJdoDialect().releaseJdbcConnection(txObject.getConnectionHolder().getConnectionHandle(), txObject.getPersistenceManagerHolder().getPersistenceManager());
            }
            catch (Exception ex) {
                this.logger.error((Object)"Could not close JDBC connection after transaction", (Throwable)ex);
            }
        }
        this.getJdoDialect().cleanupTransaction(txObject.getTransactionData());
        if (txObject.isNewPersistenceManagerHolder()) {
            PersistenceManager pm = txObject.getPersistenceManagerHolder().getPersistenceManager();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing JDO persistence manager [" + pm + "] after transaction"));
            }
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
        } else {
            this.logger.debug((Object)"Not closing pre-bound JDO persistence manager after transaction");
        }
    }

    protected DataAccessException convertJdoAccessException(JDOException ex) {
        return this.getJdoDialect().translateException(ex);
    }

    private static class SuspendedResourcesHolder {
        private final PersistenceManagerHolder persistenceManagerHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(PersistenceManagerHolder pmHolder, ConnectionHolder conHolder) {
            this.persistenceManagerHolder = pmHolder;
            this.connectionHolder = conHolder;
        }

        private PersistenceManagerHolder getPersistenceManagerHolder() {
            return this.persistenceManagerHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }

    private static class JdoTransactionObject
    extends JdbcTransactionObjectSupport {
        private PersistenceManagerHolder persistenceManagerHolder;
        private boolean newPersistenceManagerHolder;
        private Object transactionData;

        private JdoTransactionObject() {
        }

        public void setPersistenceManagerHolder(PersistenceManagerHolder persistenceManagerHolder, boolean newPersistenceManagerHolder) {
            this.persistenceManagerHolder = persistenceManagerHolder;
            this.newPersistenceManagerHolder = newPersistenceManagerHolder;
        }

        public PersistenceManagerHolder getPersistenceManagerHolder() {
            return this.persistenceManagerHolder;
        }

        public boolean isNewPersistenceManagerHolder() {
            return this.newPersistenceManagerHolder;
        }

        public boolean hasTransaction() {
            return this.persistenceManagerHolder != null && this.persistenceManagerHolder.getPersistenceManager() != null && this.persistenceManagerHolder.getPersistenceManager().currentTransaction().isActive();
        }

        public void setTransactionData(Object transactionData) {
            this.transactionData = transactionData;
        }

        public Object getTransactionData() {
            return this.transactionData;
        }

        public void setRollbackOnly() {
            this.getPersistenceManagerHolder().setRollbackOnly();
            if (this.getConnectionHolder() != null) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.getPersistenceManagerHolder().isRollbackOnly();
        }
    }
}

