/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.annotation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.beans.BeanUtils;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

public class AnnotationJmxAttributeSource
implements JmxAttributeSource {
    public org.springframework.jmx.export.metadata.ManagedResource getManagedResource(Class beanClass) throws InvalidMetadataException {
        ManagedResource ann = beanClass.getAnnotation(ManagedResource.class);
        if (ann == null) {
            return null;
        }
        ManagedResource mr = ann;
        org.springframework.jmx.export.metadata.ManagedResource attr = new org.springframework.jmx.export.metadata.ManagedResource();
        attr.setObjectName(mr.objectName());
        attr.setDescription(mr.description());
        attr.setCurrencyTimeLimit(mr.currencyTimeLimit());
        attr.setLog(mr.log());
        attr.setLogFile(mr.logFile());
        attr.setPersistPolicy(mr.persistPolicy());
        attr.setPersistPeriod(mr.persistPeriod());
        attr.setPersistLocation(mr.persistLocation());
        attr.setPersistName(mr.persistName());
        return attr;
    }

    public org.springframework.jmx.export.metadata.ManagedAttribute getManagedAttribute(Method method) throws InvalidMetadataException {
        ManagedAttribute ann = method.getAnnotation(ManagedAttribute.class);
        if (ann == null) {
            return null;
        }
        ManagedAttribute ma = ann;
        org.springframework.jmx.export.metadata.ManagedAttribute attr = new org.springframework.jmx.export.metadata.ManagedAttribute();
        attr.setDescription(ma.description());
        attr.setPersistPolicy(ma.persistPolicy());
        attr.setPersistPeriod(ma.persistPeriod());
        attr.setCurrencyTimeLimit(ma.currencyTimeLimit());
        if (ma.defaultValue().length() > 0) {
            attr.setDefaultValue(ma.defaultValue());
        }
        return attr;
    }

    public org.springframework.jmx.export.metadata.ManagedOperation getManagedOperation(Method method) throws InvalidMetadataException {
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
        if (pd != null) {
            throw new InvalidMetadataException("The ManagedOperation attribute is not valid for JavaBean properties. Use ManagedAttribute instead.");
        }
        ManagedOperation ann = method.getAnnotation(ManagedOperation.class);
        if (ann == null) {
            return null;
        }
        ManagedOperation mo = ann;
        org.springframework.jmx.export.metadata.ManagedOperation op = new org.springframework.jmx.export.metadata.ManagedOperation();
        op.setDescription(mo.description());
        op.setCurrencyTimeLimit(mo.currencyTimeLimit());
        return op;
    }

    public org.springframework.jmx.export.metadata.ManagedOperationParameter[] getManagedOperationParameters(Method method) throws InvalidMetadataException {
        ManagedOperationParameters params = method.getAnnotation(ManagedOperationParameters.class);
        org.springframework.jmx.export.metadata.ManagedOperationParameter[] result = null;
        if (params == null) {
            result = new org.springframework.jmx.export.metadata.ManagedOperationParameter[]{};
        } else {
            ManagedOperationParameter[] paramData = params.value();
            result = new org.springframework.jmx.export.metadata.ManagedOperationParameter[paramData.length];
            for (int i = 0; i < paramData.length; ++i) {
                ManagedOperationParameter mop = paramData[i];
                org.springframework.jmx.export.metadata.ManagedOperationParameter attr = new org.springframework.jmx.export.metadata.ManagedOperationParameter();
                attr.setName(mop.name());
                attr.setDescription(mop.description());
                result[i] = attr;
            }
        }
        return result;
    }
}

