/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.util.StringUtils;

public class DriverManagerDataSource
extends AbstractDataSource {
    private String driverClassName;
    private String url;
    private String username;
    private String password;

    public DriverManagerDataSource() {
    }

    public DriverManagerDataSource(String driverClassName, String url, String username, String password) throws CannotGetJdbcConnectionException {
        this.setDriverClassName(driverClassName);
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    public DriverManagerDataSource(String url, String username, String password) throws CannotGetJdbcConnectionException {
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    public DriverManagerDataSource(String url) throws CannotGetJdbcConnectionException {
        this.setUrl(url);
    }

    public void setDriverClassName(String driverClassName) throws CannotGetJdbcConnectionException {
        if (!StringUtils.hasText(driverClassName)) {
            throw new IllegalArgumentException("driverClassName must not be empty");
        }
        this.driverClassName = driverClassName;
        try {
            Class.forName(this.driverClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new CannotGetJdbcConnectionException("Could not load JDBC driver class [" + this.driverClassName + "]", ex);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loaded JDBC driver: " + this.driverClassName));
        }
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setUrl(String url) {
        if (!StringUtils.hasText(url)) {
            throw new IllegalArgumentException("url must not be empty");
        }
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriverManager();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionFromDriverManager(this.getUrl(), username, password);
    }

    protected Connection getConnectionFromDriverManager() throws SQLException {
        return this.getConnectionFromDriverManager(this.getUrl(), this.getUsername(), this.getPassword());
    }

    protected Connection getConnectionFromDriverManager(String url, String username, String password) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new JDBC connection to [" + url + "]"));
        }
        return DriverManager.getConnection(url, username, password);
    }
}

