/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.util.Iterator;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.mvc.multiaction.AbstractUrlMethodNameResolver;

public class PropertiesMethodNameResolver
extends AbstractUrlMethodNameResolver
implements InitializingBean {
    private Properties mappings;

    public void setMappings(Properties mappings) {
        this.mappings = mappings;
    }

    public void afterPropertiesSet() {
        if (this.mappings == null || this.mappings.isEmpty()) {
            throw new IllegalArgumentException("'mappings' property is required");
        }
    }

    protected String getHandlerMethodNameForUrlPath(String urlPath) {
        String methodName = this.mappings.getProperty(urlPath);
        if (methodName != null) {
            return methodName;
        }
        Iterator<Object> it = this.mappings.keySet().iterator();
        while (it.hasNext()) {
            String registeredPath = (String)it.next();
            if (!PathMatcher.match(registeredPath, urlPath)) continue;
            return (String)this.mappings.get(registeredPath);
        }
        return null;
    }
}

