/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.util.Properties;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class TransactionProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
BeanFactoryAware,
InitializingBean {
    private final TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
    private Object target;
    private Class[] proxyInterfaces;
    private Pointcut pointcut;
    private Object[] preInterceptors;
    private Object[] postInterceptors;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    private Object proxy;
    static /* synthetic */ Class class$org$springframework$transaction$PlatformTransactionManager;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionInterceptor.setTransactionManager(transactionManager);
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setProxyInterfaces(String[] interfaceNames) throws ClassNotFoundException {
        this.proxyInterfaces = AopUtils.toInterfaceArray(interfaceNames);
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        this.transactionInterceptor.setTransactionAttributes(transactionAttributes);
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionInterceptor.setTransactionAttributeSource(transactionAttributeSource);
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setPreInterceptors(Object[] preInterceptors) {
        this.preInterceptors = preInterceptors;
    }

    public void setPostInterceptors(Object[] postInterceptors) {
        this.postInterceptors = postInterceptors;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (this.transactionInterceptor.getTransactionManager() == null && beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            PlatformTransactionManager ptm = (PlatformTransactionManager)BeanFactoryUtils.beanOfTypeIncludingAncestors(lbf, class$org$springframework$transaction$PlatformTransactionManager == null ? (class$org$springframework$transaction$PlatformTransactionManager = TransactionProxyFactoryBean.class$("org.springframework.transaction.PlatformTransactionManager")) : class$org$springframework$transaction$PlatformTransactionManager);
            this.transactionInterceptor.setTransactionManager(ptm);
        }
    }

    public void afterPropertiesSet() {
        this.transactionInterceptor.afterPropertiesSet();
        if (this.target == null) {
            throw new IllegalArgumentException("'target' is required");
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        if (this.preInterceptors != null) {
            for (int i = 0; i < this.preInterceptors.length; ++i) {
                proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(this.preInterceptors[i]));
            }
        }
        if (this.pointcut != null) {
            DefaultPointcutAdvisor advice = new DefaultPointcutAdvisor(this.pointcut, (Advice)this.transactionInterceptor);
            proxyFactory.addAdvisor(advice);
        } else {
            proxyFactory.addAdvisor(new TransactionAttributeSourceAdvisor(this.transactionInterceptor));
        }
        if (this.postInterceptors != null) {
            for (int i = 0; i < this.postInterceptors.length; ++i) {
                proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(this.postInterceptors[i]));
            }
        }
        proxyFactory.copyFrom(this);
        TargetSource targetSource = this.createTargetSource(this.target);
        proxyFactory.setTargetSource(targetSource);
        if (this.proxyInterfaces != null) {
            proxyFactory.setInterfaces(this.proxyInterfaces);
        } else if (!this.isProxyTargetClass()) {
            proxyFactory.setInterfaces(AopUtils.getAllInterfacesForClass(targetSource.getTargetClass()));
        }
        this.proxy = proxyFactory.getProxy();
    }

    protected TargetSource createTargetSource(Object target) {
        if (target instanceof TargetSource) {
            return (TargetSource)target;
        }
        return new SingletonTargetSource(target);
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.proxyInterfaces != null && this.proxyInterfaces.length == 1) {
            return this.proxyInterfaces[0];
        }
        if (this.target instanceof TargetSource) {
            return ((TargetSource)this.target).getTargetClass();
        }
        if (this.target != null) {
            return this.target.getClass();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

