/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

public class TransactionAttributeSourceAdvisor
extends StaticMethodMatcherPointcutAdvisor {
    private TransactionAttributeSource transactionAttributeSource;

    public TransactionAttributeSourceAdvisor() {
    }

    public TransactionAttributeSourceAdvisor(TransactionInterceptor interceptor) {
        this.setTransactionInterceptor(interceptor);
    }

    public void setTransactionInterceptor(TransactionInterceptor interceptor) {
        this.setAdvice((Advice)interceptor);
        if (interceptor.getTransactionAttributeSource() == null) {
            throw new AopConfigException("Cannot construct a TransactionAttributeSourceAdvisor using a TransactionInterceptor that has no TransactionAttributeSource configured");
        }
        this.transactionAttributeSource = interceptor.getTransactionAttributeSource();
    }

    public boolean matches(Method method, Class targetClass) {
        Assert.notNull(this.transactionAttributeSource, "transactionAttributeSource is required");
        return this.transactionAttributeSource.getTransactionAttribute(method, targetClass) != null;
    }
}

