/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.quartz.SchedulerConfigException;
import org.quartz.impl.jdbcjobstore.JobStoreCMT;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class LocalDataSourceJobStore
extends JobStoreCMT {
    public static final String TX_DATA_SOURCE_NAME = "springTxDataSource";
    public static final String NON_TX_DATA_SOURCE_NAME = "springNonTxDataSource";
    private DataSource dataSource;

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.dataSource = SchedulerFactoryBean.getConfigTimeDataSource();
        if (this.dataSource == null) {
            throw new SchedulerConfigException("No local DataSource found for configuration - dataSource property must be set on SchedulerFactoryBean");
        }
        this.setDataSource(TX_DATA_SOURCE_NAME);
        this.setDontSetAutoCommitFalse(true);
        DBConnectionManager.getInstance().addConnectionProvider(TX_DATA_SOURCE_NAME, new ConnectionProvider(){

            public Connection getConnection() throws SQLException {
                return DataSourceUtils.getConnection(LocalDataSourceJobStore.this.dataSource);
            }

            public void shutdown() throws SQLException {
            }
        });
        this.setNonManagedTXDataSource(NON_TX_DATA_SOURCE_NAME);
        DBConnectionManager.getInstance().addConnectionProvider(NON_TX_DATA_SOURCE_NAME, new ConnectionProvider(){

            public Connection getConnection() throws SQLException {
                return LocalDataSourceJobStore.this.dataSource.getConnection();
            }

            public void shutdown() throws SQLException {
            }
        });
        super.initialize(loadHelper, signaler);
    }

    protected void closeConnection(Connection con) {
        DataSourceUtils.closeConnectionIfNecessary(con, this.dataSource);
    }
}

