/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HttpServletBean;

public class ResourceServlet
extends HttpServletBean {
    public static final String PATH_PARAM = "resource";
    private String defaultUrl;

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getParameter(PATH_PARAM);
        if (path == null) {
            throw new ServletException("Path is required");
        }
        try {
            RequestDispatcher rd = request.getRequestDispatcher(path);
            rd.include((ServletRequest)request, (ServletResponse)response);
            this.logger.debug((Object)("Included content of '" + path + "'"));
        }
        catch (Exception ex) {
            RequestDispatcher rd = request.getRequestDispatcher(this.defaultUrl);
            rd.include((ServletRequest)request, (ServletResponse)response);
            this.logger.warn((Object)("Failed to include content of '" + path + "'"));
        }
    }
}

