/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.util.Map;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessExceptionsException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;

public class DataBinder {
    public static final String MISSING_FIELD_ERROR_CODE = "required";
    private BindException errors;
    private String[] requiredFields;

    public DataBinder(Object target, String name) {
        this.errors = this.createErrors(target, name);
    }

    protected BindException createErrors(Object target, String name) {
        return new BindException(target, name);
    }

    public BindException getErrors() {
        return this.errors;
    }

    public void setRequiredFields(String[] requiredFields) {
        this.requiredFields = requiredFields;
    }

    protected String[] getRequiredFields() {
        return this.requiredFields;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.errors.getBeanWrapper().registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String field, PropertyEditor propertyEditor) {
        this.errors.getBeanWrapper().registerCustomEditor(requiredType, field, propertyEditor);
    }

    public void bind(PropertyValues pvs) {
        if (this.requiredFields != null) {
            for (int i = 0; i < this.requiredFields.length; ++i) {
                PropertyValue pv = pvs.getPropertyValue(this.requiredFields[i]);
                if (pv != null && !"".equals(pv.getValue())) continue;
                this.errors.addFieldError(new FieldError(this.errors.getObjectName(), this.requiredFields[i], (Object)"", true, MISSING_FIELD_ERROR_CODE, new Object[]{this.requiredFields[i]}, "Field '" + this.requiredFields[i] + "' is required"));
            }
        }
        try {
            this.errors.getBeanWrapper().setPropertyValues(pvs, true);
        }
        catch (PropertyAccessExceptionsException ex) {
            PropertyAccessException[] exs = ex.getPropertyAccessExceptions();
            for (int i = 0; i < exs.length; ++i) {
                this.errors.addFieldError(new FieldError(this.errors.getObjectName(), exs[i].getPropertyChangeEvent().getPropertyName(), exs[i].getPropertyChangeEvent().getNewValue(), true, exs[i].getErrorCode(), null, exs[i].getLocalizedMessage()));
            }
        }
    }

    public Map close() throws BindException {
        if (this.errors.hasErrors()) {
            throw this.errors;
        }
        return this.errors.getModel();
    }
}

