/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.object.SqlFunction;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.AbstractNextMaxValueProvider;

public class OracleSequenceMaxValueIncrementer
extends AbstractDataFieldMaxValueIncrementer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private long[] valueCache = null;
    private NextMaxValueProvider nextMaxValueProvider = new NextMaxValueProvider();

    public OracleSequenceMaxValueIncrementer() {
    }

    public OracleSequenceMaxValueIncrementer(DataSource ds, String incrementerName) {
        super(ds, incrementerName);
    }

    public OracleSequenceMaxValueIncrementer(DataSource ds, String incrementerName, int cacheSize) {
        super(ds, incrementerName, cacheSize);
    }

    public OracleSequenceMaxValueIncrementer(DataSource ds, String incrementerName, boolean prefixWithZero, int padding) {
        super(ds, incrementerName);
        this.nextMaxValueProvider.setPrefixWithZero(prefixWithZero, padding);
    }

    public OracleSequenceMaxValueIncrementer(DataSource ds, String incrementerName, boolean prefixWithZero, int padding, int cacheSize) {
        super(ds, incrementerName, cacheSize);
        this.nextMaxValueProvider.setPrefixWithZero(prefixWithZero, padding);
    }

    public void setPrefixWithZero(boolean prefixWithZero, int length) {
        this.nextMaxValueProvider.setPrefixWithZero(prefixWithZero, length);
    }

    protected int incrementIntValue() {
        return this.nextMaxValueProvider.getNextIntValue();
    }

    protected long incrementLongValue() {
        return this.nextMaxValueProvider.getNextLongValue();
    }

    protected double incrementDoubleValue() {
        return this.nextMaxValueProvider.getNextDoubleValue();
    }

    protected String incrementStringValue() {
        return this.nextMaxValueProvider.getNextStringValue();
    }

    static /* synthetic */ long[] access$102(OracleSequenceMaxValueIncrementer x0, long[] x1) {
        x0.valueCache = x1;
        return x1;
    }

    private class NextMaxValueProvider
    extends AbstractNextMaxValueProvider {
        private int nextValueIx = -1;

        private NextMaxValueProvider() {
        }

        protected long getNextKey(int type) throws DataAccessException {
            if (OracleSequenceMaxValueIncrementer.this.isDirty()) {
                this.initPrepare();
            }
            if (this.nextValueIx < 0 || this.nextValueIx >= OracleSequenceMaxValueIncrementer.this.getCacheSize()) {
                SqlFunction sqlf = new SqlFunction(OracleSequenceMaxValueIncrementer.this.getDataSource(), "SELECT " + OracleSequenceMaxValueIncrementer.this.getIncrementerName() + ".NEXTVAL FROM DUAL", type);
                sqlf.compile();
                OracleSequenceMaxValueIncrementer.access$102(OracleSequenceMaxValueIncrementer.this, new long[OracleSequenceMaxValueIncrementer.this.getCacheSize()]);
                this.nextValueIx = 0;
                for (int i = 0; i < OracleSequenceMaxValueIncrementer.this.getCacheSize(); ++i) {
                    ((OracleSequenceMaxValueIncrementer)OracleSequenceMaxValueIncrementer.this).valueCache[i] = this.getLongValue(sqlf, type);
                }
            }
            if (OracleSequenceMaxValueIncrementer.this.logger.isInfoEnabled()) {
                OracleSequenceMaxValueIncrementer.this.logger.info((Object)("Next sequence value is : " + OracleSequenceMaxValueIncrementer.this.valueCache[this.nextValueIx]));
            }
            return OracleSequenceMaxValueIncrementer.this.valueCache[this.nextValueIx++];
        }

        private void initPrepare() {
            OracleSequenceMaxValueIncrementer.this.afterPropertiesSet();
            if (OracleSequenceMaxValueIncrementer.this.getIncrementerName() == null) {
                throw new IllegalArgumentException("incrementerName property must be set on " + this.getClass().getDeclaringClass().getName());
            }
            this.nextValueIx = -1;
            OracleSequenceMaxValueIncrementer.this.setDirty(false);
        }
    }
}

