/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.AbstractNextMaxValueProvider;

public class MySQLMaxValueIncrementer
extends AbstractDataFieldMaxValueIncrementer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private NextMaxValueProvider nextMaxValueProvider = new NextMaxValueProvider();

    public MySQLMaxValueIncrementer() {
    }

    public MySQLMaxValueIncrementer(DataSource ds, String incrementerName, String columnName) {
        super(ds, incrementerName, columnName);
    }

    public MySQLMaxValueIncrementer(DataSource ds, String incrementerName, String columnName, int cacheSize) {
        super(ds, incrementerName, columnName, cacheSize);
    }

    public MySQLMaxValueIncrementer(DataSource ds, String incrementerName, String columnName, boolean prefixWithZero, int padding) {
        super(ds, incrementerName, columnName);
        this.nextMaxValueProvider.setPrefixWithZero(prefixWithZero, padding);
    }

    public MySQLMaxValueIncrementer(DataSource ds, String incrementerName, String columnName, boolean prefixWithZero, int padding, int cacheSize) {
        super(ds, incrementerName, columnName, cacheSize);
        this.nextMaxValueProvider.setPrefixWithZero(prefixWithZero, padding);
    }

    public void setPrefixWithZero(boolean prefixWithZero, int length) {
        this.nextMaxValueProvider.setPrefixWithZero(prefixWithZero, length);
    }

    protected int incrementIntValue() {
        return this.nextMaxValueProvider.getNextIntValue();
    }

    protected long incrementLongValue() {
        return this.nextMaxValueProvider.getNextLongValue();
    }

    protected double incrementDoubleValue() {
        return this.nextMaxValueProvider.getNextDoubleValue();
    }

    protected String incrementStringValue() {
        return this.nextMaxValueProvider.getNextStringValue();
    }

    private class NextMaxValueProvider
    extends AbstractNextMaxValueProvider {
        private String insertSql;
        private String updateSql = "select last_insert_id()";
        private long nextId = 0L;
        private long maxId = 0L;

        private NextMaxValueProvider() {
        }

        /*
         * Loose catch block
         */
        protected synchronized long getNextKey(int type) throws DataAccessException {
            block19: {
                block20: {
                    SQLException e2;
                    ResultSet rs;
                    Statement stmt;
                    Connection con;
                    block17: {
                        block16: {
                            if (MySQLMaxValueIncrementer.this.isDirty()) {
                                this.initPrepare();
                            }
                            if (this.maxId != this.nextId) break block20;
                            con = null;
                            stmt = null;
                            rs = null;
                            con = DataSourceUtils.getConnection(MySQLMaxValueIncrementer.this.getDataSource());
                            stmt = con.createStatement();
                            DataSourceUtils.applyTransactionTimeout(stmt, MySQLMaxValueIncrementer.this.getDataSource());
                            stmt.executeUpdate(this.insertSql);
                            rs = stmt.executeQuery(this.updateSql);
                            if (rs.next()) {
                                this.maxId = rs.getLong(1);
                                if (MySQLMaxValueIncrementer.this.logger.isInfoEnabled()) {
                                    MySQLMaxValueIncrementer.this.logger.info((Object)("new maxId is : " + this.maxId));
                                }
                            } else {
                                throw new DataAccessResourceFailureException("last_insert_id() failed after executing an update");
                            }
                            this.nextId = this.maxId - (long)MySQLMaxValueIncrementer.this.getCacheSize();
                            ++this.nextId;
                            if (!MySQLMaxValueIncrementer.this.logger.isInfoEnabled()) break block16;
                            MySQLMaxValueIncrementer.this.logger.info((Object)("nextId is : " + this.nextId));
                        }
                        Object var7_5 = null;
                        if (null == rs) break block17;
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                    }
                    if (null == stmt) break block19;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    DataSourceUtils.closeConnectionIfNecessary(con, MySQLMaxValueIncrementer.this.getDataSource());
                    {
                        break block19;
                        catch (SQLException ex) {
                            throw new DataAccessResourceFailureException("Could not obtain last_insert_id", ex);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        if (null != rs) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e2) {
                                // empty catch block
                            }
                        }
                        if (null != stmt) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException e2) {
                                // empty catch block
                            }
                            DataSourceUtils.closeConnectionIfNecessary(con, MySQLMaxValueIncrementer.this.getDataSource());
                        }
                        throw throwable;
                    }
                }
                ++this.nextId;
            }
            return this.nextId;
        }

        private void initPrepare() {
            MySQLMaxValueIncrementer.this.afterPropertiesSet();
            if (MySQLMaxValueIncrementer.this.getIncrementerName() == null) {
                throw new IllegalArgumentException("IncrementerName property must be set on " + this.getClass().getDeclaringClass().getName());
            }
            if (MySQLMaxValueIncrementer.this.getColumnName() == null) {
                throw new IllegalArgumentException("ColumnName property must be set on " + this.getClass().getDeclaringClass().getName());
            }
            StringBuffer buf = new StringBuffer();
            buf.append("update ");
            buf.append(MySQLMaxValueIncrementer.this.getIncrementerName());
            buf.append(" set ");
            buf.append(MySQLMaxValueIncrementer.this.getColumnName());
            buf.append(" = last_insert_id(");
            buf.append(MySQLMaxValueIncrementer.this.getColumnName());
            buf.append(" + ");
            buf.append(MySQLMaxValueIncrementer.this.getCacheSize());
            buf.append(")");
            this.insertSql = buf.toString();
            if (MySQLMaxValueIncrementer.this.logger.isInfoEnabled()) {
                MySQLMaxValueIncrementer.this.logger.info((Object)("insertSql = " + this.insertSql));
            }
            MySQLMaxValueIncrementer.this.setDirty(false);
        }
    }
}

