/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.datasource.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class SingleConnectionDataSource
extends DriverManagerDataSource
implements DisposableBean {
    private boolean suppressClose;
    private Connection connection;

    public SingleConnectionDataSource() {
    }

    public SingleConnectionDataSource(String driverClassName, String url, String username, String password, boolean suppressClose) throws CannotGetJdbcConnectionException {
        super(driverClassName, url, username, password);
        this.suppressClose = suppressClose;
    }

    public SingleConnectionDataSource(Connection source, boolean suppressClose) throws CannotGetJdbcConnectionException, InvalidDataAccessApiUsageException {
        if (source == null) {
            throw new InvalidDataAccessApiUsageException("Connection is null in SingleConnectionDataSource");
        }
        this.suppressClose = suppressClose;
        this.init(source);
    }

    public void setSuppressClose(boolean suppressClose) {
        this.suppressClose = suppressClose;
    }

    public boolean isSuppressClose() {
        return this.suppressClose;
    }

    public boolean shouldClose(Connection conn) {
        return false;
    }

    protected void init() throws CannotGetJdbcConnectionException {
        try {
            this.init(this.getConnectionFromDriverManager());
        }
        catch (SQLException ex) {
            throw new CannotGetJdbcConnectionException("Could not create connection", ex);
        }
    }

    protected void init(Connection source) throws CannotGetJdbcConnectionException {
        this.connection = this.suppressClose ? DataSourceUtils.getCloseSuppressingConnectionProxy(source) : source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        SingleConnectionDataSource singleConnectionDataSource = this;
        synchronized (singleConnectionDataSource) {
            if (this.connection == null) {
                this.init();
            }
        }
        if (this.connection.isClosed()) {
            throw new SQLException("Connection was closed in SingleConnectionDataSource. Check that user code checks shouldClose() before closing connections, or set suppressClose to true");
        }
        this.logger.debug((Object)("Returning single connection: " + this.connection));
        return this.connection;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (username != null && password != null && username.equals(this.getUsername()) && password.equals(this.getPassword())) {
            return this.getConnection();
        }
        throw new SQLException("SingleConnectionDataSource does not support custom username and password");
    }

    public void destroy() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

