/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import org.springframework.jdbc.core.ResultReader;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;

public class SqlOutParameter
extends SqlParameter {
    private boolean resultSetSupported = false;
    private RowCallbackHandler rowCallbackHandler = null;
    private RowMapper rowMapper = null;
    private boolean rowMapperSupported = false;
    private int rowsExpected = 0;

    public SqlOutParameter(String name, int type) {
        super(name, type);
    }

    public SqlOutParameter(String name, int type, String typeName) {
        super(name, type, typeName);
    }

    public SqlOutParameter(String name, int type, RowCallbackHandler rch) {
        super(name, type);
        this.rowCallbackHandler = rch;
        this.resultSetSupported = true;
    }

    public SqlOutParameter(String name, int type, RowMapper rm, int rowsExpected) {
        super(name, type);
        this.rowMapper = rm;
        this.resultSetSupported = true;
        this.rowsExpected = rowsExpected;
        this.rowMapperSupported = true;
    }

    public SqlOutParameter(String name, int type, RowMapper rm) {
        this(name, type, rm, 0);
    }

    public boolean isResultSetSupported() {
        return this.resultSetSupported;
    }

    public boolean isRowMapperSupported() {
        return this.rowMapperSupported;
    }

    public RowCallbackHandler getRowCallbackHandler() {
        return this.rowCallbackHandler;
    }

    protected final ResultReader newResultReader() {
        return new SqlParameter.ResultReaderStoredProcImpl(this, this.rowsExpected, this.rowMapper);
    }
}

