/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.struts;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.struts.ActionServletAwareProcessor;

public class ContextLoaderPlugIn
implements PlugIn {
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    public static final Class DEFAULT_CONTEXT_CLASS = class$org$springframework$web$context$support$XmlWebApplicationContext == null ? (class$org$springframework$web$context$support$XmlWebApplicationContext = ContextLoaderPlugIn.class$("org.springframework.web.context.support.XmlWebApplicationContext")) : class$org$springframework$web$context$support$XmlWebApplicationContext;
    public static final String SERVLET_CONTEXT_ATTRIBUTE = (class$org$springframework$web$struts$ContextLoaderPlugIn == null ? (class$org$springframework$web$struts$ContextLoaderPlugIn = ContextLoaderPlugIn.class$("org.springframework.web.struts.ContextLoaderPlugIn")) : class$org$springframework$web$struts$ContextLoaderPlugIn).getName() + ".CONTEXT";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private ActionServlet actionServlet;
    private WebApplicationContext webApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$context$support$XmlWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$struts$ContextLoaderPlugIn;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;

    public void setContextClassName(String contextClassName) throws ClassNotFoundException {
        this.contextClass = Class.forName(contextClassName, true, Thread.currentThread().getContextClassLoader());
    }

    public void setContextClass(Class contextClass) {
        this.contextClass = contextClass;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        if (this.actionServlet != null) {
            return this.actionServlet.getServletName() + DEFAULT_NAMESPACE_SUFFIX;
        }
        return null;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public final void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        long startTime = System.currentTimeMillis();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Framework servlet '" + actionServlet.getServletName() + "' init"));
        }
        this.actionServlet = actionServlet;
        try {
            this.webApplicationContext = this.initWebApplicationContext();
        }
        catch (BeansException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        this.onInit();
        if (this.logger.isInfoEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.info((Object)("Framework servlet '" + actionServlet.getServletName() + "' init completed in " + elapsedTime + " ms"));
        }
    }

    protected WebApplicationContext initWebApplicationContext() throws BeansException {
        this.actionServlet.getServletContext().log("Initializing WebApplicationContext for servlet '" + this.actionServlet.getServletName() + "'");
        ServletContext servletContext = this.actionServlet.getServletContext();
        WebApplicationContext parent = WebApplicationContextUtils.getWebApplicationContext(servletContext);
        WebApplicationContext wac = this.createWebApplicationContext(parent);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Using context class '" + wac.getClass().getName() + "' for servlet '" + this.actionServlet.getServletName() + "'"));
        }
        servletContext.setAttribute(SERVLET_CONTEXT_ATTRIBUTE, (Object)wac);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Published WebApplicationContext of servlet '" + this.actionServlet.getServletName() + "' as ServletContext attribute with name [" + SERVLET_CONTEXT_ATTRIBUTE + "]"));
        }
        return wac;
    }

    protected WebApplicationContext createWebApplicationContext(WebApplicationContext parent) throws BeansException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Servlet with name '" + this.actionServlet.getServletName() + "' will try to create custom WebApplicationContext context of class '" + this.getContextClass().getName() + "'" + " using parent context [" + parent + "]"));
        }
        if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = ContextLoaderPlugIn.class$("org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(this.getContextClass())) {
            throw new ApplicationContextException("Fatal initialization error in servlet with name '" + this.actionServlet.getServletName() + "': custom WebApplicationContext class [" + this.getContextClass().getName() + "] is not of type ConfigurableWebApplicationContext");
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass(this.getContextClass());
        wac.setParent(parent);
        wac.setServletContext(this.actionServlet.getServletContext());
        wac.setNamespace(this.getNamespace());
        if (this.contextConfigLocation != null) {
            wac.setConfigLocations(StringUtils.tokenizeToStringArray(this.contextConfigLocation, ",; ", true, true));
        }
        wac.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
                beanFactory.addBeanPostProcessor(new ActionServletAwareProcessor(ContextLoaderPlugIn.this.actionServlet));
            }
        });
        wac.refresh();
        return wac;
    }

    public final ActionServlet getActionServlet() {
        return this.actionServlet;
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected void onInit() throws ServletException {
    }

    public void destroy() {
        this.actionServlet.getServletContext().log("Closing WebApplicationContext of servlet '" + this.actionServlet.getServletName() + "'");
        if (this.webApplicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)((Object)this.webApplicationContext)).close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

