/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import org.springframework.core.Constants;
import org.springframework.transaction.TransactionDefinition;

public class DefaultTransactionDefinition
implements TransactionDefinition {
    public static final String TIMEOUT_PREFIX = "timeout_";
    public static final String READ_ONLY_MARKER = "readOnly";
    private static final Constants constants = new Constants(class$org$springframework$transaction$TransactionDefinition == null ? (class$org$springframework$transaction$TransactionDefinition = DefaultTransactionDefinition.class$("org.springframework.transaction.TransactionDefinition")) : class$org$springframework$transaction$TransactionDefinition);
    private int propagationBehavior = 0;
    private int isolationLevel = -1;
    private int timeout = -1;
    private boolean readOnly = false;
    static /* synthetic */ Class class$org$springframework$transaction$TransactionDefinition;

    public DefaultTransactionDefinition() {
    }

    public DefaultTransactionDefinition(int propagationBehavior) {
        this.propagationBehavior = propagationBehavior;
    }

    public final void setPropagationBehaviorName(String constantName) throws IllegalArgumentException {
        if (constantName == null || !constantName.startsWith("PROPAGATION")) {
            throw new IllegalArgumentException("Only propagation constants allowed");
        }
        this.setPropagationBehavior(constants.asNumber(constantName).intValue());
    }

    public final void setPropagationBehavior(int propagationBehavior) {
        if (!constants.getValues("PROPAGATION").contains(new Integer(propagationBehavior))) {
            throw new IllegalArgumentException("Only values of propagation constants allowed");
        }
        this.propagationBehavior = propagationBehavior;
    }

    public final int getPropagationBehavior() {
        return this.propagationBehavior;
    }

    public final void setIsolationLevelName(String constantName) throws IllegalArgumentException {
        if (constantName == null || !constantName.startsWith("ISOLATION")) {
            throw new IllegalArgumentException("Only isolation constants allowed");
        }
        this.setIsolationLevel(constants.asNumber(constantName).intValue());
    }

    public final void setIsolationLevel(int isolationLevel) {
        if (!constants.getValues("ISOLATION").contains(new Integer(isolationLevel))) {
            throw new IllegalArgumentException("Only values of isolation constants allowed");
        }
        this.isolationLevel = isolationLevel;
    }

    public final int getIsolationLevel() {
        return this.isolationLevel;
    }

    public final void setTimeout(int timeout) {
        if (timeout < -1) {
            throw new IllegalArgumentException("Timeout must be a positive integer or TIMEOUT_DEFAULT");
        }
        this.timeout = timeout;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean equals(Object other) {
        return other instanceof TransactionDefinition && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getDefinitionDescription().toString();
    }

    protected final StringBuffer getDefinitionDescription() {
        StringBuffer desc = new StringBuffer();
        desc.append(constants.toCode(new Integer(this.propagationBehavior), "PROPAGATION"));
        desc.append(',');
        desc.append(constants.toCode(new Integer(this.isolationLevel), "ISOLATION"));
        if (this.timeout != -1) {
            desc.append(',');
            desc.append(TIMEOUT_PREFIX + this.timeout);
        }
        if (this.readOnly) {
            desc.append(',');
            desc.append(READ_ONLY_MARKER);
        }
        return desc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

