/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.support.JdbcUtils;

public class DatabaseStartupValidator
implements InitializingBean {
    public static final int DEFAULT_INTERVAL = 1;
    public static final int DEFAULT_TIMEOUT = 60;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private String validationQuery;
    private int interval = 1;
    private int timeout = 60;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource is required");
        }
        if (this.validationQuery == null) {
            throw new IllegalArgumentException("validationQuery is required");
        }
        boolean validated = false;
        long beginTime = System.currentTimeMillis();
        long deadLine = beginTime + (long)(this.timeout * 1000);
        SQLException latestEx = null;
        while (!validated && System.currentTimeMillis() < deadLine) {
            block18: {
                SQLException ex2222;
                Object var12_12;
                Connection con = null;
                Statement stmt = null;
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.createStatement();
                    stmt.execute(this.validationQuery);
                    validated = true;
                    var12_12 = null;
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    JdbcUtils.closeStatement(stmt);
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException ex2222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                JdbcUtils.closeStatement(stmt);
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException ex2222) {}
                }
                break block18;
                {
                    catch (SQLException ex3) {
                        latestEx = ex3;
                        this.logger.debug((Object)("Validation query [" + this.validationQuery + "] threw exception"), (Throwable)ex3);
                        float rest = (float)(deadLine - System.currentTimeMillis()) / 1000.0f;
                        if (rest > (float)this.interval) {
                            this.logger.warn((Object)("Database has not started up yet - retrying in " + this.interval + " seconds (timeout in " + rest + " seconds)"));
                        }
                        var12_12 = null;
                        JdbcUtils.closeStatement(stmt);
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException ex2222) {}
                        }
                    }
                }
            }
            try {
                Thread.sleep(this.interval * 1000);
            }
            catch (InterruptedException ex) {}
        }
        if (!validated) {
            throw new CannotGetJdbcConnectionException("Database has not started up within " + this.timeout + " seconds", latestEx);
        }
        float duration = (System.currentTimeMillis() - beginTime) / 1000L;
        this.logger.info((Object)("Database startup detected after " + duration + " seconds"));
    }
}

