/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.beans.PropertyEditor;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

public class CustomEditorConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Map customEditors;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setCustomEditors(Map customEditors) {
        this.customEditors = customEditors;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.customEditors != null) {
            Iterator it = this.customEditors.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Class<?> requiredType = null;
                if (key instanceof Class) {
                    requiredType = (Class<?>)key;
                } else if (key instanceof String) {
                    String className = (String)key;
                    try {
                        requiredType = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException ex) {
                        throw new BeanInitializationException("Could not load required type [" + className + "] for custom editor", ex);
                    }
                } else {
                    throw new BeanInitializationException("Invalid key [" + key + "] for custom editor - " + "needs to be Class or String");
                }
                Object value = this.customEditors.get(key);
                if (!(value instanceof PropertyEditor)) {
                    throw new BeanInitializationException("Mapped value for custom editor is not of type java.beans.PropertyEditor");
                }
                beanFactory.registerCustomEditor(requiredType, (PropertyEditor)value);
            }
        }
    }
}

