/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ClassFilters;
import org.springframework.aop.support.MethodMatchers;

public class ComposablePointcut
implements Pointcut {
    private ClassFilter classFilter;
    private MethodMatcher methodMatcher;

    public ComposablePointcut() {
        this.classFilter = ClassFilter.TRUE;
        this.methodMatcher = MethodMatcher.TRUE;
    }

    public ComposablePointcut(ClassFilter classFilter, MethodMatcher methodMatcher) {
        this.classFilter = classFilter;
        this.methodMatcher = methodMatcher;
    }

    public ComposablePointcut union(ClassFilter filter) {
        this.classFilter = ClassFilters.union(this.classFilter, filter);
        return this;
    }

    public ComposablePointcut intersection(ClassFilter filter) {
        this.classFilter = ClassFilters.intersection(this.classFilter, filter);
        return this;
    }

    public ComposablePointcut union(MethodMatcher mm) {
        this.methodMatcher = MethodMatchers.union(this.methodMatcher, mm);
        return this;
    }

    public ComposablePointcut intersection(MethodMatcher mm) {
        this.methodMatcher = MethodMatchers.intersection(this.methodMatcher, mm);
        return this;
    }

    public ComposablePointcut intersection(Pointcut other) {
        this.classFilter = ClassFilters.intersection(this.classFilter, other.getClassFilter());
        this.methodMatcher = MethodMatchers.intersection(this.methodMatcher, other.getMethodMatcher());
        return this;
    }

    public ClassFilter getClassFilter() {
        return this.classFilter;
    }

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }
}

