/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class PathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ResourceLoader resourceLoader;
    private ClassLoader classLoader;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public PathMatchingResourcePatternResolver() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public PathMatchingResourcePatternResolver(ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
        this.classLoader = classLoader;
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader, ClassLoader classLoader) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
        this.classLoader = classLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull(pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public Resource getResource(String location) {
        return this.getResourceLoader().getResource(location);
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        Assert.notNull(locationPattern, "locationPattern is required");
        if (locationPattern.startsWith("classpath*:")) {
            if (this.getPathMatcher().isPattern(locationPattern.substring("classpath*:".length()))) {
                return this.findPathMatchingResources(locationPattern);
            }
            return this.findAllClassPathResources(locationPattern.substring("classpath*:".length()));
        }
        if (this.getPathMatcher().isPattern(locationPattern)) {
            return this.findPathMatchingResources(locationPattern);
        }
        return new Resource[]{this.getResourceLoader().getResource(locationPattern)};
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        ClassLoader cl;
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((cl = this.getClassLoader()) == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Enumeration<URL> resourceUrls = cl.getResources(path);
        HashSet<UrlResource> result = new HashSet<UrlResource>();
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(new UrlResource(StringUtils.cleanPath(url.toString())));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.getResources(rootDirPath);
        HashSet result = new HashSet();
        for (int i = 0; i < rootDirResources.length; ++i) {
            Resource rootDirResource = rootDirResources[i];
            if ("jar".equals(rootDirResource.getURL().getProtocol())) {
                result.addAll(this.doFindPathMatchingJarResources(rootDirResource, subPattern));
                continue;
            }
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern));
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Resolved location pattern [" + locationPattern + "] to resources " + result));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected String determineRootDir(String location) {
        int rootDirEnd;
        int patternStart = location.length();
        int prefixEnd = location.indexOf(":");
        int asteriskIndex = location.indexOf(42, prefixEnd);
        int questionMarkIndex = location.indexOf(63, prefixEnd);
        if (asteriskIndex != -1 || questionMarkIndex != -1) {
            int n = patternStart = asteriskIndex > questionMarkIndex ? asteriskIndex : questionMarkIndex;
        }
        if ((rootDirEnd = location.lastIndexOf(47, patternStart)) == -1) {
            rootDirEnd = location.lastIndexOf(":", patternStart) + 1;
        }
        return rootDirEnd != -1 ? location.substring(0, rootDirEnd) : "";
    }

    protected Set doFindPathMatchingJarResources(Resource rootDirResource, String subPattern) throws IOException {
        String rootEntryPath;
        URLConnection con = rootDirResource.getURL().openConnection();
        if (!(con instanceof JarURLConnection)) {
            throw new IOException("Cannot perform jar file search for [" + rootDirResource + "]: connection [" + con + "] is not an instance of [java.net.JarURLConnection]");
        }
        JarURLConnection jarCon = (JarURLConnection)con;
        JarFile jarFile = jarCon.getJarFile();
        URL jarFileUrl = jarCon.getJarFileURL();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for matching resources in jar file [" + jarFileUrl + "]"));
        }
        if ((rootEntryPath = jarCon.getJarEntry().getName()).endsWith("/")) {
            rootEntryPath = rootEntryPath.substring(0, rootEntryPath.length() - 1);
        }
        String jarFileUrlPrefix = "jar:" + jarFileUrl.toExternalForm() + "!/";
        HashSet<UrlResource> result = new HashSet<UrlResource>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryPath = entry.getName();
            if (!entryPath.startsWith(rootEntryPath) || !this.getPathMatcher().match(subPattern, entryPath.substring(rootEntryPath.length()))) continue;
            result.add(new UrlResource(new URL(jarFileUrlPrefix + entryPath)));
        }
        return result;
    }

    protected Set doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        File rootDir = rootDirResource.getFile().getAbsoluteFile();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for matching resources in directory tree [" + rootDir.getPath() + "]"));
        }
        Set matchingFiles = this.retrieveMatchingFiles(rootDir, subPattern);
        HashSet<FileSystemResource> result = new HashSet<FileSystemResource>(matchingFiles.size());
        Iterator it = matchingFiles.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            result.add(new FileSystemResource(file));
        }
        return result;
    }

    protected Set retrieveMatchingFiles(File rootDir, String pattern) throws IOException {
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("'rootDir' parameter [" + rootDir + "] does not denote a directory");
        }
        String fullPattern = StringUtils.replace(rootDir.getAbsolutePath(), File.separator, "/");
        if (!pattern.startsWith("/")) {
            fullPattern = fullPattern + "/";
        }
        fullPattern = fullPattern + StringUtils.replace(pattern, File.separator, "/");
        HashSet result = new HashSet();
        this.doRetrieveMatchingFiles(fullPattern, rootDir, result);
        return result;
    }

    protected void doRetrieveMatchingFiles(String fullPattern, File dir, Set result) throws IOException {
        File[] dirContents;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searching directory [" + dir.getAbsolutePath() + "] for files matching pattern [" + fullPattern + "]"));
        }
        if ((dirContents = dir.listFiles()) == null) {
            throw new IOException("Could not retrieve contents of directory [" + dir.getAbsolutePath() + "]");
        }
        boolean dirDepthNotFixed = fullPattern.indexOf("**") != -1;
        for (int i = 0; i < dirContents.length; ++i) {
            String currPath = StringUtils.replace(dirContents[i].getAbsolutePath(), File.separator, "/");
            if (dirContents[i].isDirectory() && (dirDepthNotFixed || StringUtils.countOccurrencesOf(currPath, "/") < StringUtils.countOccurrencesOf(fullPattern, "/"))) {
                this.doRetrieveMatchingFiles(fullPattern, dirContents[i], result);
            }
            if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
            result.add(dirContents[i]);
        }
    }
}

