/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.StringUtils;

public class ServiceLocatorFactoryBean
implements FactoryBean,
BeanFactoryAware,
InitializingBean {
    private Class serviceLocatorInterface;
    private Properties serviceMappings;
    private ListableBeanFactory beanFactory;
    private Object proxy;

    public void setServiceLocatorInterface(Class interfaceName) {
        this.serviceLocatorInterface = interfaceName;
    }

    public void setServiceMappings(Properties serviceMappings) {
        this.serviceMappings = serviceMappings;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new FatalBeanException("ServiceLocatorFactoryBean needs to run in a BeanFactory that is a ListableBeanFactory");
        }
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws BeansException {
        if (this.serviceLocatorInterface == null) {
            throw new FatalBeanException("serviceLocatorInterface is required");
        }
        this.proxy = Proxy.newProxyInstance(this.serviceLocatorInterface.getClassLoader(), new Class[]{this.serviceLocatorInterface}, (InvocationHandler)new ServiceLocatorInvocationHandler());
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        return this.serviceLocatorInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    private class ServiceLocatorInvocationHandler
    implements InvocationHandler {
        private ServiceLocatorInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                String mappedName;
                Class<?>[] paramTypes = method.getParameterTypes();
                Method interfaceMethod = ServiceLocatorFactoryBean.this.serviceLocatorInterface.getMethod(method.getName(), paramTypes);
                Class<?> serviceLocatorReturnType = interfaceMethod.getReturnType();
                if (paramTypes.length > 1 || Void.TYPE.equals(serviceLocatorReturnType)) {
                    throw new UnsupportedOperationException("May only call methods with signature '<type> xxx()' or '<type> xxx(<idtype> id)' on factory interface, but tried to call: " + interfaceMethod);
                }
                String beanName = "";
                if (args != null && args.length == 1 && args[0] != null) {
                    beanName = args[0].toString();
                }
                if (ServiceLocatorFactoryBean.this.serviceMappings != null && (mappedName = ServiceLocatorFactoryBean.this.serviceMappings.getProperty(beanName)) != null) {
                    beanName = mappedName;
                }
                if (StringUtils.hasLength(beanName)) {
                    return ServiceLocatorFactoryBean.this.beanFactory.getBean(beanName, serviceLocatorReturnType);
                }
                return BeanFactoryUtils.beanOfTypeIncludingAncestors(ServiceLocatorFactoryBean.this.beanFactory, serviceLocatorReturnType);
            }
            catch (NoSuchMethodException ex) {
                try {
                    return method.invoke((Object)this, args);
                }
                catch (InvocationTargetException invEx) {
                    throw invEx.getTargetException();
                }
            }
        }

        public String toString() {
            return "Service locator: " + ServiceLocatorFactoryBean.this.serviceLocatorInterface.getName();
        }
    }
}

