/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResourceLoader;

public abstract class GenericFilterBean
implements Filter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set requiredProperties = new HashSet();
    private FilterConfig filterConfig;
    static /* synthetic */ Class class$org$springframework$core$io$Resource;

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void setFilterConfig(FilterConfig filterConfig) {
        try {
            this.init(filterConfig);
        }
        catch (ServletException ex) {
            throw new FatalBeanException("Couldn't initialize filter bean", (Throwable)ex);
        }
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.logger.info((Object)("Initializing filter '" + filterConfig.getFilterName() + "'"));
        this.filterConfig = filterConfig;
        try {
            FilterConfigPropertyValues pvs = new FilterConfigPropertyValues(filterConfig, this.requiredProperties);
            BeanWrapperImpl bw = new BeanWrapperImpl((Object)this);
            ServletContextResourceLoader resourceLoader = new ServletContextResourceLoader(filterConfig.getServletContext());
            bw.registerCustomEditor(class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = GenericFilterBean.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource, (PropertyEditor)new ResourceEditor((ResourceLoader)resourceLoader));
            this.initBeanWrapper((BeanWrapper)bw);
            bw.setPropertyValues((PropertyValues)pvs);
        }
        catch (BeansException ex) {
            String msg = "Failed to set bean properties on filter '" + filterConfig.getFilterName() + "': " + ex.getMessage();
            this.logger.error((Object)msg, (Throwable)ex);
            throw new ServletException(msg, (Throwable)ex);
        }
        this.initFilterBean();
        this.logger.info((Object)("Filter '" + filterConfig.getFilterName() + "' configured successfully"));
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    public final FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected final String getFilterName() {
        return this.filterConfig.getFilterName();
    }

    protected final ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected void initFilterBean() throws ServletException {
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FilterConfigPropertyValues
    extends MutablePropertyValues {
        private FilterConfigPropertyValues(FilterConfig config, Set requiredProperties) throws ServletException {
            HashSet missingProps = requiredProperties != null && !requiredProperties.isEmpty() ? new HashSet(requiredProperties) : null;
            Enumeration enumeration = config.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                String property = (String)enumeration.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, (Object)value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (missingProps != null && missingProps.size() > 0) {
                throw new ServletException("Initialization from FilterConfig for filter '" + config.getFilterName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, (String)", "));
            }
        }
    }
}

