/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.context.ApplicationEvent;

public class RequestHandledEvent
extends ApplicationEvent {
    private String url;
    private long timeMillis;
    private String ipAddress;
    private String method;
    private String servletName;
    private Throwable failureCause;

    public RequestHandledEvent(Object source, String url, long timeMillis, String ipAddress, String method, String servletName) {
        super(source);
        this.url = url;
        this.timeMillis = timeMillis;
        this.ipAddress = ipAddress;
        this.method = method;
        this.servletName = servletName;
    }

    public RequestHandledEvent(Object source, String url, long timeMillis, String ipAddress, String method, String servletName, Throwable ex) {
        this(source, url, timeMillis, ipAddress, method, servletName);
        this.failureCause = ex;
    }

    public String getURL() {
        return this.url;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getMethod() {
        return this.method;
    }

    public String getServletName() {
        return this.servletName;
    }

    public boolean wasFailure() {
        return this.failureCause != null;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestHandledEvent: url=[");
        sb.append(this.getURL()).append("] time=").append(this.getTimeMillis()).append("ms");
        sb.append(" client=").append(this.getIpAddress()).append(" method='").append(this.getMethod());
        sb.append("' servlet='").append(this.getServletName()).append("'");
        sb.append(" status=");
        if (!this.wasFailure()) {
            sb.append("OK");
        } else {
            sb.append("failed: ").append(this.getFailureCause());
        }
        return sb.toString();
    }
}

