/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import org.springframework.util.Assert;

public class SerializableListDataModel
extends DataModel
implements Serializable {
    private int rowIndex = 0;
    private List data;

    public SerializableListDataModel() {
        this(new ArrayList());
    }

    public SerializableListDataModel(List list) {
        if (list == null) {
            list = new ArrayList();
        }
        this.setWrappedData(list);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object getRowData() {
        Assert.isTrue((boolean)this.isRowAvailable(), (String)(this.getClass() + " is in an illegal state - no row is available at the current index."));
        return this.data.get(this.rowIndex);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object getWrappedData() {
        return this.data;
    }

    public boolean isRowAvailable() {
        return this.rowIndex >= 0 && this.rowIndex < this.data.size();
    }

    public void setRowIndex(int newRowIndex) {
        if (newRowIndex < -1) {
            throw new IllegalArgumentException("Illegal row index for " + this.getClass() + ": " + newRowIndex);
        }
        int oldRowIndex = this.rowIndex;
        this.rowIndex = newRowIndex;
        if (this.data != null && oldRowIndex != this.rowIndex) {
            Object row = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent((DataModel)this, this.rowIndex, row);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            data = new ArrayList();
        }
        Assert.isInstanceOf(List.class, data, (String)("The data object for " + this.getClass() + " must be a List"));
        this.data = data;
        int newRowIndex = 0;
        this.setRowIndex(newRowIndex);
    }

    public String toString() {
        return this.data.toString();
    }
}

