/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.engine.VariableValueFactory;
import org.springframework.webflow.execution.RequestContext;

public class BeanFactoryVariableValueFactory
implements VariableValueFactory {
    private Class type;
    private AutowireCapableBeanFactory beanFactory;

    public BeanFactoryVariableValueFactory(Class type, AutowireCapableBeanFactory beanFactory) {
        this.type = type;
        this.beanFactory = beanFactory;
    }

    public Object createInitialValue(RequestContext context) {
        return this.beanFactory.createBean(this.type);
    }

    public void restoreReferences(Object value, RequestContext context) {
        if (value != null) {
            this.beanFactory.autowireBean(value);
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("type", (Object)this.type).toString();
    }
}

