/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.cli;

import java.util.Arrays;
import org.realityforge.cli.CLOptionDescriptor;

public final class CLOption {
    public static final int TEXT_ARGUMENT = 0;
    private String[] m_arguments;
    private CLOptionDescriptor m_descriptor;

    public final String getArgument() {
        return this.getArgument(0);
    }

    public final String getArgument(int index) {
        if (null == this.m_arguments || index < 0 || index >= this.m_arguments.length) {
            return null;
        }
        return this.m_arguments[index];
    }

    public final int getId() {
        return this.m_descriptor == null ? 0 : this.m_descriptor.getId();
    }

    public final CLOptionDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public CLOption(CLOptionDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public CLOption(String argument) {
        this((CLOptionDescriptor)null);
        this.addArgument(argument);
    }

    public final void addArgument(String argument) {
        if (null == this.m_arguments) {
            this.m_arguments = new String[]{argument};
        } else {
            String[] arguments = new String[this.m_arguments.length + 1];
            System.arraycopy(this.m_arguments, 0, arguments, 0, this.m_arguments.length);
            arguments[this.m_arguments.length] = argument;
            this.m_arguments = arguments;
        }
    }

    public final int getArgumentCount() {
        if (null == this.m_arguments) {
            return 0;
        }
        return this.m_arguments.length;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Option ");
        sb.append((char)this.m_descriptor.getId());
        if (null != this.m_arguments) {
            sb.append(", ");
            sb.append(Arrays.asList(this.m_arguments));
        }
        sb.append(" ]");
        return sb.toString();
    }
}

